% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetRectCmat.R
\name{GetRectCmat}
\alias{GetRectCmat}
\title{GetRectCmat}
\usage{
GetRectCmat(CubeCP1, CubeCP2, RV = TRUE)
}
\arguments{
\item{CubeCP1}{A 3D array of cross-product matrices}

\item{CubeCP2}{A 3D array of cross-product matrices}

\item{RV}{Boolean, if TRUE, GetCmat computes the matrix of the RV coefficients between all the slices of the 3D array, otherwise, GetCmat computes a scalar product.}
}
\value{
A rectangular matrix of either RV coefficients or scalar products.
}
\description{
Computes the rectangular RV coefficient matrix between two arrays of conformable matrices
}
\examples{
\donttest{
D3.1 <- array(c(0, 1, 2, 1, 0, 1, 2, 1, 0, 
              0, 3, 3, 3, 0, 3, 3, 3, 0), 
            dim = c(3, 3, 2))
D3.2 <- array(c(1, 0, 0, 0, 1, 0, 0, 0, 1, 
                 1, 1, 1, 1, 1, 1, 1, 1, 1, 
                 0, 0, 0, 0, 0, 0, 0, 0, 0), 
            dim = c(3, 3, 3))
GetRectCmat(D3.1, D3.2)             
}
}
