% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DTAT-package.R
\docType{data}
\name{dtat1000}
\alias{dtat1000}
\title{Precomputed neutrophil-guided chemotherapy dose titration for 1000 simulated
subjects.}
\format{
A data frame showing end-of-cycle state of neutrophil-guided dose
titration for 1000 simulated subjects, across 10 cycles of chemotherapy.
\describe{
\item{cycle}{Cycle number 1..10}
\item{id}{Subject identifiers; an ordered factor with levels
\code{id1} < \dots{} < \code{id1000}}
\item{Cc}{Central-compartment drug concentration}
\item{Cp}{Peripheral-compartment drug concentration}
\item{Prol}{Progenitor cells in proliferating compartment of
Friberg et al. (2002) model}
\item{Tx.1}{Transit compartment 1}
\item{Tx.2}{Transit compartment 1}
\item{Tx.3}{Transit compartment 1}
\item{Circ}{Concentration (cells/mm^3) of circulating neutrophils}
\item{dose}{Dose of 1-hour infusion administered this cycle}
\item{CircMin}{Neutrophil nadir (cells/mm^3)}
\item{tNadir}{Time (days) of neutrophil nadir}
\item{scaled.dose}{Fourth root of dose}
\item{time}{Time (weeks) of dose administration}
}
}
\description{
This dataset is provided to support fast reproduction of a forthcoming
pharmacoeconomic paper that includes examination of the empirical
distribution of MTDi in N=1000 simulated subjects.
}
\details{
Running the examples interactively, you can verify the reproducibility of
this dataset. (That demo is included in a \code{donttest} block to spare the
CRAN servers.)
}
\examples{

data(dtat1000)
# 1. Extract the N final doses, assuming convergence by the tenth course
MTD_i <- with(dtat1000, dose[time==27])
MTD_i <- MTD_i[MTD_i < 5000] # Exclude few outliers
# 2. Do a kernel density plot
library(Hmisc)
library(latticeExtra)
hist <- histogram(~MTD_i, breaks=c(0,100,200,300,400,600,900,1500,2500,4000,5000)
                  , xlab=expression(MTD[i]))
approx <- data.frame(mtd_i=seq(0, 5000, 10))
approx <- upData(approx,
                 gamma = dgamma(mtd_i, shape=1.75, scale=200))
dist <- xyplot(gamma ~ mtd_i, data=approx, type='l', col='black', lwd=2)
library(grid)
hist + dist
grid.text(expression(MTD[i] \%~\%
                     paste("Gamma(", alpha==1.75, ", ", beta==1/200,")"))
         , x=unit(0.5,"npc")
         , y=unit(0.75,"npc")
         )
## A very long repro, which a user of this package may well wish to verify
## by running the examples interactively, although it takes many minutes
## to compute.  (Enclosed in a dontest block to avoid overburdening CRAN.)
\donttest{
# Demonstrate close reproduction of original titration (the titration takes many minutes!)
set.seed(2016)
library(pomp)
Onoue.Friberg(N=1000)
# This titration may take an hour to run ...
chemo <- titrate(doserange = c(50, 3000),
                 dta=newton.raphson(dose1 = 100,
                                    omega = 0.75,
                                    slope1 = -2.0,
                                    slopeU = -0.2)
)

dtat1k <- upData(chemo$course
                , time = 3*(cycle-1)
                , labels = c(time="Time")
                , units = c(time="weeks")
                , print = FALSE)

c10dose1k <- subset(dtat1k, cycle==10)$scaled.dose
c10dose1000 <- subset(dtat1000, cycle==10)$scaled.dose
stopifnot(0.999 < cor(c10dose1k, c10dose1000))
}

}
\references{
\enumerate{
\item Norris DC. Dose Titration Algorithm Tuning (DTAT) should
supersede \sQuote{the} Maximum Tolerated Dose (MTD) in oncology dose-finding
trials. \emph{F1000Research}. 2017;6:112. \doi{10.12688/f1000research.10624.3}.
\url{https://f1000research.com/articles/6-112/v3}
\item Norris DC. Costing \sQuote{the} MTD. \emph{bioRxiv}. August 2017:150821.
\doi{10.1101/150821}.
\url{https://www.biorxiv.org/content/10.1101/150821v3}
}
}
\keyword{datasets}
