% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPLS.R
\name{PPLS}
\alias{PPLS}
\title{Penalized Partial Least Squares (PPLS) Estimation}
\usage{
PPLS(d, yidx, Xidx, n, lam = 0.005)
}
\arguments{
\item{d}{Containing the dependent and independent variables.}

\item{yidx}{Column index of the dependent variable in \code{d}.}

\item{Xidx}{Column indices of the independent variables in \code{d}.}

\item{n}{Vector of sample sizes for each group.}

\item{lam}{Regularization parameter for ridge regression (default is 0.005).}
}
\value{
A list containing the following elements:
\item{beta}{Regression coefficients.}
\item{SSE}{Residual sum of squares.}
\item{df}{Number of complete cases used in the estimation.}
\item{gram}{Gram matrix (\eqn{X^TX + \lambda I}).}
\item{cgram}{Cholesky decomposition of the Gram matrix.}
\item{comm}{Indicator variable (0 for single group, 1 for multiple groups).}
}
\description{
This function performs Penalized Partial Least Squares (PPLS) estimation for grouped data.
It supports ridge regression regularization and handles missing data by excluding incomplete cases.
The function returns regression coefficients, residual sum of squares, and other diagnostic information.
}
\details{
This function assumes that the data is grouped and that the sample sizes for each group are provided.
It excludes cases with missing values in the dependent or independent variables.
The function uses Cholesky decomposition to solve the regularized least squares problem.
}
\examples{
# Example data
set.seed(123)
n_total <- 1000
p <- 5
n_groups <- c(300, 300, 400)
d <- list(all = cbind(rnorm(n_total), matrix(rnorm(n_total*p), ncol=p)),p = p)

# Call PPLS function
result <- PPLS(d, yidx=1, Xidx=2:(p+1), n=n_groups)

# View results
print(result$beta)  # Regression coefficients
print(result$SSE)   # Residual sum of squares

}
