% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelSelection.R
\name{model_selection_data}
\alias{model_selection_data}
\title{Prepare data for visualising model selection}
\usage{
model_selection_data(
  models,
  metric = c("AIC", "BIC", "AICc", "BICc", "deviance"),
  sort = FALSE,
  breakup = FALSE,
  model_names = names(models)
)
}
\arguments{
\item{models}{List of statistical regression model objects.}

\item{metric}{Metric used for comparisons between models. Takes values
from c("AIC", "BIC", "AICc", "BICc", "logLik").
Can choose a single or multiple metrics for comparing the
different models.}

\item{sort}{A boolean value indicating whether to sort the model from
highest to lowest value of chosen metric.}

\item{breakup}{A boolean value indicating whether to breakup the metric value
into deviance (defined as -2*loglikelihood) and
penalty components. Will work only if a single metric out of
"AIC", "AICc", "BIC", or "BICc" is chosen to plot.}

\item{model_names}{A character string describing the names to display
on X-axis for each model in order they appear in the
models parameter.}
}
\value{
A data-frame with multiple columns containing values of several
        information criteria for each model specified in `models`.
 \describe{
   \item{model_name}{An identifier name for each model object to be shown on X-axis.}
   \item{deviance}{The deviance values for each model object.}
   \item{logLik}{The -2*Log-Likelihood values for each model object.}
   \item{AIC}{The Akaike information criteria (AIC) values for each model object.}
   \item{BIC}{The Bayesian information criteria (BIC) values for each model object.}
   \item{AICc}{The corrected AIC (AICc) values for each model object.}
   \item{BICc}{The corrected BIC (BICc) values for each model object.}
   \item{Component}{The names of the components to be shown in the plot.}
   \item{Value}{The values for the components to be shown in the plot.}
 }
}
\description{
The data preparation function for visualising model selection. The output of this
function can be passed to the \code{\link{model_selection_plot}} function for
showing a visual comparison between the information criteria for different models.
It is also possible to visualise a breakup of the information criteria into
deviance (goodness-of-fit) and penalty terms for each model.
}
\examples{
## Fit different candidate models
mod1 <- lm(mpg ~ disp, data = mtcars)
mod2 <- lm(mpg ~ disp + hp, data = mtcars)
mod3 <- lm(mpg ~ disp + hp + wt, data = mtcars)
mod4 <- lm(mpg ~ disp + hp + wt + carb, data = mtcars)

## Group models into list
models_list <- list("Model 1" = mod1, "Model 2" = mod2,
                    "Model 3" = mod3, "Model 4" = mod4)

## Prepare data for visualisation
## Specific metric
model_selection_data(models = models_list,
                     metric = c("AIC"))

## Multiple metrics can be plotted together as well
model_selection_data(models = models_list,
                     metric = c("AIC", "BIC"))

## If single metric is specified then breakup of metric
## between goodness of fit and penalty can also be visualised
model_selection_data(models = models_list,
                     metric = c("AICc"),
                     breakup = TRUE)

## Sort models
model_selection_data(models = models_list,
                     metric = c("AICc"),
                     breakup = TRUE, sort = TRUE)

## If multiple metrics are specified then sorting
## will be done on first metric specified in list (AIC in this case)
model_selection_data(models = models_list,
                     metric = c("AIC", "BIC", "AICc", "BICc"), sort = TRUE)
}
