% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust_round.R
\name{robust_round}
\alias{robust_round}
\title{Round numbers without problems.}
\usage{
robust_round(
  x,
  digits = 2,
  thousands_separator = "",
  decimal_separator = ".",
  lower_indicator = TRUE
)
}
\arguments{
\item{x}{(numeric) The numeric input vector to round.}

\item{digits}{(int, optional) The number of digits after the decimal
separator to round to.}

\item{thousands_separator}{(string, optional) Used as mark between every 3
decimals before the decimal point.}

\item{decimal_separator}{(string, optional) The character to be used to
indicate the numeric decimal point.}

\item{lower_indicator}{(Boolaen, optional, default = TRUE) If the result is
(since it is rounded) zero: Should there be displayed a lower-indicator?
E.g. \code{DIZtools::robust_round(0.00001)} results internally in "0.00".
The more intuitive result therefore would be "<0.01", which can be enabled
using the parameter `lower_indicator == TRUE`.}
}
\value{
Rounded numbers as string.
}
\description{
Round numbers without problems.
}
\examples{
{
  robust_round(c(1.234567, 987123.987654321))
  #> [1] "1.23"   "987.99"
}
}
