% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_back_colonisation.R
\name{is_back_colonisation}
\alias{is_back_colonisation}
\title{Checks whether species has undergone back-colonisation from}
\usage{
is_back_colonisation(phylod, node_label)
}
\arguments{
\item{phylod}{A \code{phylo4d} object from the package \code{phylobase} containing
phylogenetic and endemicity data for each species.}

\item{node_label}{A numeric label for a node within a phylogeny.}
}
\value{
A character string or FALSE. Character string is in the format
ancestral_node -> focal_node, where the ancestral node is not on mainland
but the focal node is.
}
\description{
Checks whether species has undergone back-colonisation from
}
\examples{
set.seed(
3,
kind = "Mersenne-Twister",
normal.kind = "Inversion",
sample.kind = "Rejection"
)
phylo <- ape::rcoal(5)
phylo$tip.label <- c("bird_a", "bird_b", "bird_c", "bird_d", "bird_e")
phylo <- phylobase::phylo4(phylo)
endemicity_status <- c("endemic", "endemic", "not_present",
                       "endemic", "not_present")
phylod <- phylobase::phylo4d(phylo, as.data.frame(endemicity_status))
phylod <- add_asr_node_states(phylod = phylod, asr_method = "parsimony")
# aritificially modify data to produce back-colonisation
phylobase::tdata(phylod)$island_status[8] <- "endemic"
# Example without back colonisation
is_back_colonisation(phylod = phylod, node_label = 2)
# Example with back colonisation
is_back_colonisation(phylod = phylod, node_label = 3)
}
