% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licenses.R
\name{cds_accepted_licences}
\alias{cds_accepted_licences}
\title{List accepted licences}
\usage{
cds_accepted_licences(
  scope = c("all", "dataset", "portal"),
  ...,
  token = cds_get_token()
)
}
\arguments{
\item{scope}{Scope of the licenses to be listed should be one of \code{"all"} (default),
\code{"dataset"} or \code{"portal"}.}

\item{...}{Ignored}

\item{token}{An API key to be used for authentication. Will use
\code{cds_get_token()} by default.}
}
\value{
Returns a \code{data.frame} listing the accepted licenses.
}
\description{
In order to use specific features of the Climate Data Service, you may first
need to accept specific licences. This function will list all licenses you
have accepted.
}
\examples{
if (interactive() && cds_token_works()) {
  cds_accepted_licences("portal")
}
}
