% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regZIC.test.R
\name{regZIC.test}
\alias{regZIC.test}
\title{Test whether two ZIC values differ significantly based on minimum ZIC for regression data}
\usage{
regZIC.test(model1,model2,model_ZIC="AIC",data,alpha=0.05)
}
\arguments{
\item{model1}{an object of class ``lm".}

\item{model2}{an object of class ``lm".}

\item{model_ZIC}{type of the information criterion, it can be "AIC", "BIC", or "AICc" (Default is the "AIC").}

\item{data}{a matrix of \eqn{n} by \eqn{(m+1)} where \eqn{m} is the number of independent variables.First column should be the dependent variable and the rest of the \eqn{m} columns should be the independent variables of the dataset. Maximum of \eqn{m} should be 10.}

\item{alpha}{significance level \eqn{\alpha} for the hypothesis testing (Default is 0.05).}
}
\value{
p-value with significance status.
}
\description{
Test whether two ZIC values differ significantly based on minimum ZIC for regression data.
}
\details{
Consider the hypothesis: Under the null hypothesis that the two expected discrepancies are equal.

\deqn{H_0: ZIC_i=ZIC_j     ,    H_1: ZIC_i\neq ZIC_j}

\deqn{Z_0=\frac{(\hat{ZIC_i}-\hat{ZIC_j})-0}{\sqrt{SD(ZIC_i,ZIC_j)}}\sim N(0,1)}  is calculated empirically.
}
\examples{
library(ConfZIC)
data(Concrete)
x=Concrete
Y=x[,9] #dependent variable
#independent variables
X1=x[,1];X2=x[,2];X3=x[,3];X4=x[,4];
X5=x[,5];X6=x[,6];X7=x[,7];X8=x[,8];
mydata=cbind(Y,X1,X2,X3,X4,X5,X6,X7,X8) #data matrix
model1=lm(Y~X1); model2=lm(Y~X1+X2)
regZIC.test(model1,model2,model_ZIC="BIC",data=mydata,alpha=0.05)
}
\references{
Linhart, H. (1988). A test whether two AIC's differ significantly. South African Statistical Journal, 22(2), 153-161.
}
