% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimationCKT.datasetPairs.R
\name{computeMatrixSignPairs}
\alias{computeMatrixSignPairs}
\title{Compute the matrix of signs of pairs}
\usage{
computeMatrixSignPairs(vectorX1, vectorX2, typeEstCKT = 4)
}
\arguments{
\item{vectorX1}{vector of observed data (first coordinate)}

\item{vectorX2}{vector of observed data (second coordinate)}

\item{typeEstCKT}{if typeEstCKT = 2 or 4, compute the matrix whose term (i,j) is :
   \deqn{1 \{ (X_{i,1} - X_{j,1}) * (X_{i,2} - X_{j,2}) > 0 \}
 - 1 \{ (X_{i,1} - X_{j,1}) * (X_{i,2} - X_{j,2}) < 0 \},}
 where \eqn{1} is the indicator function.

For \code{typeEstCKT = 1} (respectively \code{typeEstCKT = 3})
a negatively biased (respectively positively) matrix is given.}
}
\value{
an \code{n * n} matrix with the signs of each pair
of observations.
}
\description{
Compute a matrix giving the concordance or discordance
of each pair of observations.
}
\examples{
# We simulate from a conditional copula
N = 500
Z = rnorm(n = N, mean = 5, sd = 2)
conditionalTau = 0.9 * pnorm(Z, mean = 5, sd = 2)
simCopula = VineCopula::BiCopSim(N = N , family = 3,
    par = VineCopula::BiCopTau2Par(1 , conditionalTau) )
matrixPairs = computeMatrixSignPairs(vectorX1 = simCopula[,1],
                                     vectorX2 = simCopula[,2])

}
