% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_model_from_metamodel.R
\name{create_model_from_metamodel}
\alias{create_model_from_metamodel}
\title{Use to create model object from parsed metamodel}
\usage{
create_model_from_metamodel(mmdlfile, directoryToRun)
}
\arguments{
\item{mmdlfile}{File with metamodel description}

\item{directoryToRun}{Directory where the results will be stored; if
\code{missing}, a subfolder in the current directory with the model name given
in \code{parsedMetamodel} will be created}
}
\value{
a list  with the resulted model class instance and engine parameters.
If multiple ESTARGS/SIMARGS blocks are used, a list of estimation argument
classes (\code{\link[=NlmeEngineExtraParams]{NlmeEngineExtraParams()}}) and simulation argument classes
(\code{simParamsBlock}) are returned.
}
\description{
Define NlmePmlModel model class instance from metamodel blocks and creates
NlmePmlModel model class from the given parsed metamodel. See
\href{https://certara.github.io/R-RsNLME/articles/metamodels_overview.html}{Metamodel
overview}.
}
\examples{
 \donttest{
   ModelParamsList <-
     create_model_from_metamodel(
       mmdlfile = system.file("extdata/mmdlNoTime", "test.mmdl",
                              package = "Certara.RsNLME"),
       directoryToRun = tempdir())
 }

}
\seealso{
\code{\link[=run_metamodel]{run_metamodel()}}
}
\keyword{internal}
