% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{downsampling}
\alias{downsampling}
\title{Downsampling Cells}
\usage{
downsampling(
  metadata,
  n.size = 35,
  seed = NULL,
  include = FALSE,
  replace = FALSE,
  lower.cutoff = 3
)
}
\arguments{
\item{metadata}{A data frame containing at least two columns: one for group labels
and one for batch information. Each row corresponds to a single cell. Required.}

\item{n.size}{Numeric value specifying the number of cells to use in each group.
Default is \code{35}.}

\item{seed}{Numeric value to set the random seed for sampling. Default is \code{12345}.}

\item{include}{Logical value indicating whether to include groups that have fewer cells than \code{n.size}.
Default is \code{FALSE}.}

\item{replace}{Logical value specifying whether to sample with replacement if a group
is smaller than \code{n.size}. Default is \code{FALSE}.}

\item{lower.cutoff}{Numeric value indicating the minimum group size required for inclusion.
Default is \code{3}.}
}
\value{
A list of numeric indices (or cell names) for cells to be kept for downstream computation.
}
\description{
Downsamples cells from each group for IDER-based similarity calculation.
}
\examples{
  # 'meta' is a data frame with columns 'label' and 'batch'
  meta <- data.frame(
    label = c(rep("A", 40), rep("A", 35), rep("B", 20)),
    batch = c(rep("X", 40), rep("Y", 35), rep("X", 20))
  )
  keep_cells <- downsampling(meta, n.size = 35, seed = 12345)
  
  # Display the selected indices
  print(keep_cells)

}
