% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CBTF-package.R
\docType{package}
\name{CBTF-package}
\alias{CBTF}
\alias{CBTF-package}
\title{CBTF: Caught by the Fuzz! A minimalistic fuzz-test runner}
\description{
This package implements a very simple mechanism for fuzz-testing functions
in the public interface of an R package.
}
\details{
Fuzz testing helps identify functions lacking sufficient argument validation,
and uncovers sets of inputs that, while valid by function signature, may
cause issues within the function body.

The core functionality of the package is \link{fuzz}, whose aim is to call
each provided function with a certain input and record the output produced.
If an error is generated, this is captured and reported to the user, unless
the error message matches a pattern of whitelisted errors. The objects
returned by \link{fuzz} can be printed with \link{print.cbtf} and \link{summary.cbtf}.

The helper function \link{get_exported_functions} identifies the functions
in the public interface of a given package, facilitating the generation of
the list of functions to be fuzzed.

Function \link{test_inputs} by default generates a large set of potentially
problematic inputs, but they can be limited just to the desired classes of
inputs.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://mcol.github.io/caught-by-the-fuzz/}
  \item Report bugs at \url{https://github.com/mcol/caught-by-the-fuzz/issues}
}

}
\author{
\strong{Maintainer}: Marco Colombo \email{mar.colombo13@gmail.com} (\href{https://orcid.org/0000-0001-6672-0623}{ORCID})

}
