% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Prior.R
\name{createBarPrior}
\alias{createBarPrior}
\title{Create a BAR Cyclops prior object}
\usage{
createBarPrior(
  penalty = "bic",
  exclude = c(),
  forceIntercept = FALSE,
  fitBestSubset = FALSE,
  initialRidgeVariance = 10000,
  tolerance = 1e-08,
  maxIterations = 10000,
  threshold = 1e-06,
  delta = 0
)
}
\arguments{
\item{penalty}{Specifies the BAR penalty; possible values are `BIC` or `AIC` or a numeric value}

\item{exclude}{A vector of numbers or covariateId names to exclude from prior}

\item{forceIntercept}{Logical: Force intercept coefficient into regularization}

\item{fitBestSubset}{Logical: Fit final subset with no regularization}

\item{initialRidgeVariance}{Numeric: variance used for algorithm initiation}

\item{tolerance}{Numeric: maximum abs change in coefficient estimates from successive iterations to achieve convergence}

\item{maxIterations}{Numeric: maxium iterations to achieve convergence}

\item{threshold}{Numeric: absolute threshold at which to force coefficient to 0}

\item{delta}{Numeric: change from 2 in ridge norm dimension}
}
\value{
A BAR Cyclops prior object of class inheriting from
\code{"cyclopsPrior"} for use with \code{fitCyclopsModel}.
}
\description{
\code{createBarPrior} creates a BAR Cyclops prior object for use with \code{\link{fitCyclopsModel}}.
}
\examples{
prior <- createBarPrior(penalty = "bic")

}
