// Copyright 2018 Google LLC. All Rights Reserved.
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

// This file was automatically generated by the program contained in the source
// file write_poisson_mixture_tables.cpp.
#include <vector>
#include "LinAlg/Vector.hpp"
#include "Models/Glm/PosteriorSamplers/NormalMixtureApproximation.hpp"

namespace BOOM {
  void fill_poisson_mixture_approximation_table_2(
      NormalMixtureApproximationTable *table) {
    //----------------------------------------------------------------------
    // nu = 50 kl = 2.64783e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.98141, -3.87251, -3.81191}),
          BOOM::Vector({0.117707, 0.123482, 0.146629}),
          BOOM::Vector({0.376334, 0.43382, 0.189846}));
      table->add(50, spec);
    }

    //----------------------------------------------------------------------
    // nu = 51 kl = 2.11589e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.00996, -3.82333, -3.90863}),
          BOOM::Vector({0.115191, 0.144569, 0.127194}),
          BOOM::Vector({0.262852, 0.155639, 0.581509}));
      table->add(51, spec);
    }

    //----------------------------------------------------------------------
    // nu = 52 kl = 2.03428e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.92841, -3.8446, -4.02856}),
          BOOM::Vector({0.125977, 0.143146, 0.114212}),
          BOOM::Vector({0.580247, 0.156833, 0.26292}));
      table->add(52, spec);
    }

    //----------------------------------------------------------------------
    // nu = 53 kl = 1.95708e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.0469, -3.94795, -3.86482}),
          BOOM::Vector({0.113237, 0.124879, 0.141695}),
          BOOM::Vector({0.261559, 0.582032, 0.156409}));
      table->add(53, spec);
    }

    //----------------------------------------------------------------------
    // nu = 54 kl = 1.8842e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.88501, -3.96705, -4.06488}),
          BOOM::Vector({0.140327, 0.123767, 0.112296}),
          BOOM::Vector({0.156927, 0.582228, 0.260845}));
      table->add(54, spec);
    }

    //----------------------------------------------------------------------
    // nu = 55 kl = 1.81526e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.9048, -3.9858, -4.08253}),
          BOOM::Vector({0.138996, 0.122686, 0.111379}),
          BOOM::Vector({0.157421, 0.58244, 0.260139}));
      table->add(55, spec);
    }

    //----------------------------------------------------------------------
    // nu = 56 kl = 1.75009e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.00404, -3.92438, -4.09975}),
          BOOM::Vector({0.121587, 0.137723, 0.110513}),
          BOOM::Vector({0.580721, 0.158374, 0.260906}));
      table->add(56, spec);
    }

    //----------------------------------------------------------------------
    // nu = 57 kl = 1.68811e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.11685, -4.02222, -3.94306}),
          BOOM::Vector({0.109626, 0.120614, 0.136423}),
          BOOM::Vector({0.259188, 0.582959, 0.157853}));
      table->add(57, spec);
    }

    //----------------------------------------------------------------------
    // nu = 58 kl = 1.62951e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-3.96219, -4.13375, -4.04016}),
          BOOM::Vector({0.135242, 0.108741, 0.119611}),
          BOOM::Vector({0.159506, 0.257201, 0.583293}));
      table->add(58, spec);
    }

    //----------------------------------------------------------------------
    // nu = 59 kl = 1.57368e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.15, -4.05736, -3.98}),
          BOOM::Vector({0.107958, 0.11864, 0.133993}),
          BOOM::Vector({0.258347, 0.583244, 0.15841}));
      table->add(59, spec);
    }

    //----------------------------------------------------------------------
    // nu = 60 kl = 1.52073e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.16612, -3.99793, -4.0744}),
          BOOM::Vector({0.107166, 0.13282, 0.117681}),
          BOOM::Vector({0.258509, 0.158549, 0.582942}));
      table->add(60, spec);
    }

    //----------------------------------------------------------------------
    // nu = 61 kl = 1.47033e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.01576, -4.09138, -4.18213}),
          BOOM::Vector({0.131698, 0.116767, 0.106356}),
          BOOM::Vector({0.159271, 0.583766, 0.256963}));
      table->add(61, spec);
    }

    //----------------------------------------------------------------------
    // nu = 62 kl = 1.42238e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.19777, -4.03309, -4.10791}),
          BOOM::Vector({0.105591, 0.130584, 0.115863}),
          BOOM::Vector({0.256685, 0.159422, 0.583893}));
      table->add(62, spec);
    }

    //----------------------------------------------------------------------
    // nu = 63 kl = 1.3767e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.21315, -4.12417, -4.05013}),
          BOOM::Vector({0.104846, 0.114978, 0.129499}),
          BOOM::Vector({0.2565, 0.583919, 0.15958}));
      table->add(63, spec);
    }

    //----------------------------------------------------------------------
    // nu = 64 kl = 1.33314e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.22836, -4.06699, -4.14025}),
          BOOM::Vector({0.104101, 0.128449, 0.11412}),
          BOOM::Vector({0.255612, 0.160045, 0.584342}));
      table->add(64, spec);
    }

    //----------------------------------------------------------------------
    // nu = 65 kl = 1.29169e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.156, -4.084, -4.2433}),
          BOOM::Vector({0.113231, 0.12747, 0.103385}),
          BOOM::Vector({0.582568, 0.161755, 0.255677}));
      table->add(65, spec);
    }

    //----------------------------------------------------------------------
    // nu = 66 kl = 1.26485e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.16958, -4.25667, -4.10257}),
          BOOM::Vector({0.111825, 0.10296, 0.126714}),
          BOOM::Vector({0.556843, 0.273677, 0.16948}));
      table->add(66, spec);
    }

    //----------------------------------------------------------------------
    // nu = 67 kl = 1.21403e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.27253, -4.18687, -4.11584}),
          BOOM::Vector({0.101989, 0.111647, 0.125435}),
          BOOM::Vector({0.254196, 0.584819, 0.160985}));
      table->add(67, spec);
    }

    //----------------------------------------------------------------------
    // nu = 68 kl = 1.18451e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.20066, -4.28597, -4.13389}),
          BOOM::Vector({0.110405, 0.101497, 0.124714}),
          BOOM::Vector({0.564644, 0.266605, 0.168751}));
      table->add(68, spec);
    }

    //----------------------------------------------------------------------
    // nu = 69 kl = 1.15575e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.21485, -4.14997, -4.29963}),
          BOOM::Vector({0.109443, 0.123824, 0.100919}),
          BOOM::Vector({0.556393, 0.17116, 0.272446}));
      table->add(69, spec);
    }

    //----------------------------------------------------------------------
    // nu = 70 kl = 1.10997e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.31472, -4.16232, -4.23133}),
          BOOM::Vector({0.100021, 0.122608, 0.109328}),
          BOOM::Vector({0.253594, 0.161452, 0.584954}));
      table->add(70, spec);
    }

    //----------------------------------------------------------------------
    // nu = 71 kl = 1.07818e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.32846, -4.17743, -4.24581}),
          BOOM::Vector({0.0993773, 0.121715, 0.108597}),
          BOOM::Vector({0.252649, 0.161867, 0.585484}));
      table->add(71, spec);
    }

    //----------------------------------------------------------------------
    // nu = 72 kl = 1.04778e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.34183, -4.25986, -4.19211}),
          BOOM::Vector({0.0987843, 0.107858, 0.120822}),
          BOOM::Vector({0.253695, 0.584729, 0.161576}));
      table->add(72, spec);
    }

    //----------------------------------------------------------------------
    // nu = 73 kl = 1.01852e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.35527, -4.27402, -4.20693}),
          BOOM::Vector({0.0981485, 0.10716, 0.11998}),
          BOOM::Vector({0.251959, 0.585592, 0.162448}));
      table->add(73, spec);
    }

    //----------------------------------------------------------------------
    // nu = 74 kl = 1.03561e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.28316, -4.36519, -4.22551}),
          BOOM::Vector({0.105192, 0.0981362, 0.11957}),
          BOOM::Vector({0.524956, 0.297233, 0.177811}));
      table->add(74, spec);
    }

    //----------------------------------------------------------------------
    // nu = 75 kl = 1.01874e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.29636, -4.2403, -4.37806}),
          BOOM::Vector({0.104234, 0.118711, 0.0975526}),
          BOOM::Vector({0.516256, 0.182015, 0.301729}));
      table->add(75, spec);
    }

    //----------------------------------------------------------------------
    // nu = 76 kl = 9.37793e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.25002, -4.39432, -4.31509}),
          BOOM::Vector({0.117547, 0.0963602, 0.10511}),
          BOOM::Vector({0.164595, 0.249436, 0.585969}));
      table->add(76, spec);
    }

    //----------------------------------------------------------------------
    // nu = 77 kl = 9.51062e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.32394, -4.2674, -4.40395}),
          BOOM::Vector({0.103233, 0.117085, 0.0963475}),
          BOOM::Vector({0.527664, 0.178921, 0.293415}));
      table->add(77, spec);
    }

    //----------------------------------------------------------------------
    // nu = 78 kl = 9.3385e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.33644, -4.28103, -4.41605}),
          BOOM::Vector({0.10245, 0.116293, 0.0958492}),
          BOOM::Vector({0.521414, 0.179637, 0.298949}));
      table->add(78, spec);
    }

    //----------------------------------------------------------------------
    // nu = 79 kl = 8.66528e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.43119, -4.35373, -4.2898}),
          BOOM::Vector({0.09481, 0.103165, 0.115104}),
          BOOM::Vector({0.25406, 0.584711, 0.161229}));
      table->add(79, spec);
    }

    //----------------------------------------------------------------------
    // nu = 80 kl = 8.58374e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.36462, -4.30669, -4.44214}),
          BOOM::Vector({0.101851, 0.114712, 0.0945077}),
          BOOM::Vector({0.550451, 0.175007, 0.274542}));
      table->add(80, spec);
    }

    //----------------------------------------------------------------------
    // nu = 81 kl = 8.60314e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.37518, -4.45288, -4.32061}),
          BOOM::Vector({0.100678, 0.0941888, 0.113997}),
          BOOM::Vector({0.525253, 0.294782, 0.179966}));
      table->add(81, spec);
    }

    //----------------------------------------------------------------------
    // nu = 82 kl = 8.03358e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.46694, -4.39118, -4.32861}),
          BOOM::Vector({0.0932957, 0.101319, 0.112851}),
          BOOM::Vector({0.256524, 0.583521, 0.159955}));
      table->add(82, spec);
    }

    //----------------------------------------------------------------------
    // nu = 83 kl = 7.86943e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.34659, -4.40529, -4.4803}),
          BOOM::Vector({0.112664, 0.100617, 0.0924545}),
          BOOM::Vector({0.179422, 0.579964, 0.240614}));
      table->add(83, spec);
    }

    //----------------------------------------------------------------------
    // nu = 84 kl = 7.64759e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.35758, -4.49152, -4.41707}),
          BOOM::Vector({0.111808, 0.0920324, 0.100119}),
          BOOM::Vector({0.173376, 0.24307, 0.583554}));
      table->add(84, spec);
    }

    //----------------------------------------------------------------------
    // nu = 85 kl = 7.46016e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.50174, -4.42765, -4.36674}),
          BOOM::Vector({0.0917931, 0.0995834, 0.110804}),
          BOOM::Vector({0.255493, 0.583288, 0.161219}));
      table->add(85, spec);
    }

    //----------------------------------------------------------------------
    // nu = 86 kl = 7.85167e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.43435, -4.38469, -4.50979}),
          BOOM::Vector({0.0973963, 0.110607, 0.0918276}),
          BOOM::Vector({0.503303, 0.186232, 0.310465}));
      table->add(86, spec);
    }

    //----------------------------------------------------------------------
    // nu = 87 kl = 7.90422e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.44473, -4.52019, -4.39764}),
          BOOM::Vector({0.0964164, 0.0914389, 0.109955}),
          BOOM::Vector({0.48438, 0.323939, 0.19168}));
      table->add(87, spec);
    }

    //----------------------------------------------------------------------
    // nu = 88 kl = 7.0869e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.46117, -4.53433, -4.40754}),
          BOOM::Vector({0.0972338, 0.0905478, 0.109249}),
          BOOM::Vector({0.546465, 0.274439, 0.179095}));
      table->add(88, spec);
    }

    //----------------------------------------------------------------------
    // nu = 89 kl = 6.79289e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.54606, -4.47399, -4.41482}),
          BOOM::Vector({0.089954, 0.0973886, 0.108167}),
          BOOM::Vector({0.257124, 0.582164, 0.160713}));
      table->add(89, spec);
    }

    //----------------------------------------------------------------------
    // nu = 90 kl = 7.04892e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.4812, -4.43174, -4.55427}),
          BOOM::Vector({0.0955292, 0.107992, 0.0899176}),
          BOOM::Vector({0.513349, 0.183771, 0.30288}));
      table->add(90, spec);
    }

    //----------------------------------------------------------------------
    // nu = 91 kl = 6.65203e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.56554, -4.49363, -4.43845}),
          BOOM::Vector({0.0894326, 0.0957509, 0.106932}),
          BOOM::Vector({0.288149, 0.548809, 0.163042}));
      table->add(91, spec);
    }

    //----------------------------------------------------------------------
    // nu = 92 kl = 6.39984e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.45595, -4.50932, -4.57986}),
          BOOM::Vector({0.106939, 0.0956107, 0.0882841}),
          BOOM::Vector({0.187042, 0.571837, 0.241122}));
      table->add(92, spec);
    }

    //----------------------------------------------------------------------
    // nu = 93 kl = 6.63514e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.51433, -4.58602, -4.46668}),
          BOOM::Vector({0.0939488, 0.0885932, 0.106224}),
          BOOM::Vector({0.508729, 0.30412, 0.187151}));
      table->add(93, spec);
    }

    //----------------------------------------------------------------------
    // nu = 94 kl = 6.22145e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.59701, -4.52655, -4.47235}),
          BOOM::Vector({0.0881303, 0.094294, 0.105138}),
          BOOM::Vector({0.287305, 0.549828, 0.162867}));
      table->add(94, spec);
    }

    //----------------------------------------------------------------------
    // nu = 95 kl = 5.99143e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.60832, -4.53874, -4.48398}),
          BOOM::Vector({0.0875279, 0.0940823, 0.104641}),
          BOOM::Vector({0.271119, 0.564528, 0.164353}));
      table->add(95, spec);
    }

    //----------------------------------------------------------------------
    // nu = 96 kl = 6.58166e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.54409, -4.61532, -4.50134}),
          BOOM::Vector({0.0918022, 0.0874958, 0.104542}),
          BOOM::Vector({0.473638, 0.329375, 0.196987}));
      table->add(96, spec);
    }

    //----------------------------------------------------------------------
    // nu = 97 kl = 8.73004e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.54869, -4.52187, -4.62252}),
          BOOM::Vector({0.088371, 0.104394, 0.0870316}),
          BOOM::Vector({0.355348, 0.265644, 0.379009}));
      table->add(97, spec);
    }

    //----------------------------------------------------------------------
    // nu = 98 kl = 7.61673e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.63477, -4.56278, -4.53085}),
          BOOM::Vector({0.0864565, 0.0891233, 0.103866}),
          BOOM::Vector({0.347926, 0.402465, 0.24961}));
      table->add(98, spec);
    }

    //----------------------------------------------------------------------
    // nu = 99 kl = 6.32786e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.64538, -4.53535, -4.5753}),
          BOOM::Vector({0.0862141, 0.103017, 0.0901978}),
          BOOM::Vector({0.329375, 0.208275, 0.46235}));
      table->add(99, spec);
    }

    //----------------------------------------------------------------------
    // nu = 100 kl = 6.63769e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.65534, -4.58517, -4.54958}),
          BOOM::Vector({0.0856735, 0.089188, 0.102766}),
          BOOM::Vector({0.330849, 0.438094, 0.231057}));
      table->add(100, spec);
    }

    //----------------------------------------------------------------------
    // nu = 101 kl = 6.13174e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.66487, -4.5956, -4.55698}),
          BOOM::Vector({0.0854103, 0.0892749, 0.102043}),
          BOOM::Vector({0.328803, 0.458559, 0.212638}));
      table->add(101, spec);
    }

    //----------------------------------------------------------------------
    // nu = 106 kl = 5.43971e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.64416, -4.60478, -4.71134}),
          BOOM::Vector({0.0874343, 0.0993075, 0.0836819}),
          BOOM::Vector({0.466175, 0.199961, 0.333864}));
      table->add(106, spec);
    }

    //----------------------------------------------------------------------
    // nu = 111 kl = 4.65684e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.65617, -4.69682, -4.7606}),
          BOOM::Vector({0.0973821, 0.0864351, 0.0812929}),
          BOOM::Vector({0.21621, 0.517472, 0.266317}));
      table->add(111, spec);
    }

    //----------------------------------------------------------------------
    // nu = 116 kl = 4.05032e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.80136, -4.73948, -4.69375}),
          BOOM::Vector({0.0801067, 0.085155, 0.0944986}),
          BOOM::Vector({0.28532, 0.542742, 0.171938}));
      table->add(116, spec);
    }

    //----------------------------------------------------------------------
    // nu = 121 kl = 3.69977e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.84284, -4.78262, -4.73891}),
          BOOM::Vector({0.0785101, 0.0834347, 0.0925906}),
          BOOM::Vector({0.279446, 0.542162, 0.178391}));
      table->add(121, spec);
    }

    //----------------------------------------------------------------------
    // nu = 126 kl = 4.14947e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.8161, -4.87748, -4.78503}),
          BOOM::Vector({0.0797618, 0.0775775, 0.0908209}),
          BOOM::Vector({0.419003, 0.370578, 0.210418}));
      table->add(126, spec);
    }

    //----------------------------------------------------------------------
    // nu = 131 kl = 3.34216e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.91854, -4.86034, -4.82302}),
          BOOM::Vector({0.0759215, 0.0796098, 0.0889684}),
          BOOM::Vector({0.312263, 0.496441, 0.191296}));
      table->add(131, spec);
    }

    //----------------------------------------------------------------------
    // nu = 136 kl = 3.45035e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.89509, -4.86476, -4.95318}),
          BOOM::Vector({0.077175, 0.0874164, 0.0747769}),
          BOOM::Vector({0.433935, 0.214873, 0.351192}));
      table->add(136, spec);
    }

    //----------------------------------------------------------------------
    // nu = 141 kl = 2.81572e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.99097, -4.89957, -4.93568}),
          BOOM::Vector({0.0733271, 0.0857355, 0.077047}),
          BOOM::Vector({0.298704, 0.193501, 0.507794}));
      table->add(141, spec);
    }

    //----------------------------------------------------------------------
    // nu = 146 kl = 2.97884e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.96677, -4.93762, -5.02236}),
          BOOM::Vector({0.0746219, 0.0842439, 0.0724111}),
          BOOM::Vector({0.433355, 0.213488, 0.353157}));
      table->add(146, spec);
    }

    //----------------------------------------------------------------------
    // nu = 151 kl = 2.87955e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-4.9998, -4.9729, -5.0546}),
          BOOM::Vector({0.0731457, 0.0828112, 0.0713557}),
          BOOM::Vector({0.414293, 0.219501, 0.366206}));
      table->add(151, spec);
    }

    //----------------------------------------------------------------------
    // nu = 156 kl = 2.34677e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.0893, -5.03712, -5.00491}),
          BOOM::Vector({0.0700393, 0.0731566, 0.0814452}),
          BOOM::Vector({0.307554, 0.489967, 0.20248}));
      table->add(156, spec);
    }

    //----------------------------------------------------------------------
    // nu = 161 kl = 2.59314e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.06391, -5.0393, -5.11681}),
          BOOM::Vector({0.0707527, 0.0801372, 0.0693326}),
          BOOM::Vector({0.39944, 0.224292, 0.376268}));
      table->add(161, spec);
    }

    //----------------------------------------------------------------------
    // nu = 166 kl = 2.31059e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.07436, -5.15089, -5.10017}),
          BOOM::Vector({0.0792934, 0.0678154, 0.0704058}),
          BOOM::Vector({0.249228, 0.300343, 0.450429}));
      table->add(166, spec);
    }

    //----------------------------------------------------------------------
    // nu = 171 kl = 3.57229e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.17715, -5.11105, -5.12468}),
          BOOM::Vector({0.0667846, 0.0782447, 0.0669565}),
          BOOM::Vector({0.354803, 0.334664, 0.310533}));
      table->add(171, spec);
    }

    //----------------------------------------------------------------------
    // nu = 176 kl = 2.91604e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.20652, -5.13943, -5.1558}),
          BOOM::Vector({0.0658857, 0.0771437, 0.0668333}),
          BOOM::Vector({0.33505, 0.314858, 0.350092}));
      table->add(176, spec);
    }

    //----------------------------------------------------------------------
    // nu = 181 kl = 3.038e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.23286, -5.1693, -5.18252}),
          BOOM::Vector({0.0650983, 0.0763332, 0.0658684}),
          BOOM::Vector({0.346587, 0.320363, 0.33305}));
      table->add(181, spec);
    }

    //----------------------------------------------------------------------
    // nu = 186 kl = 3.09097e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.25991, -5.21066, -5.19779}),
          BOOM::Vector({0.0642326, 0.0653989, 0.0755366}),
          BOOM::Vector({0.334685, 0.347689, 0.317626}));
      table->add(186, spec);
    }

    //----------------------------------------------------------------------
    // nu = 191 kl = 1.89261e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.23613, -5.21582, -5.2839}),
          BOOM::Vector({0.0650136, 0.0734789, 0.0640963}),
          BOOM::Vector({0.379549, 0.23674, 0.383712}));
      table->add(191, spec);
    }

    //----------------------------------------------------------------------
    // nu = 196 kl = 1.64027e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.31112, -5.26496, -5.24203}),
          BOOM::Vector({0.0631625, 0.0648208, 0.0725705}),
          BOOM::Vector({0.343995, 0.425925, 0.23008}));
      table->add(196, spec);
    }

    //----------------------------------------------------------------------
    // nu = 200 kl = 1.54618e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.33133, -5.28591, -5.2628}),
          BOOM::Vector({0.0625361, 0.0643217, 0.0718508}),
          BOOM::Vector({0.335008, 0.435223, 0.229769}));
      table->add(200, spec);
    }

    //----------------------------------------------------------------------
    // nu = 210 kl = 1.40445e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.37922, -5.33518, -5.31308}),
          BOOM::Vector({0.0611322, 0.0628258, 0.0701089}),
          BOOM::Vector({0.333843, 0.432764, 0.233393}));
      table->add(210, spec);
    }

    //----------------------------------------------------------------------
    // nu = 220 kl = 2.09546e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.42488, -5.38085, -5.36856}),
          BOOM::Vector({0.0594517, 0.0601231, 0.0689684}),
          BOOM::Vector({0.332187, 0.332165, 0.335648}));
      table->add(220, spec);
    }

    //----------------------------------------------------------------------
    // nu = 230 kl = 1.47114e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.46857, -5.42608, -5.41081}),
          BOOM::Vector({0.0583997, 0.0592876, 0.067191}),
          BOOM::Vector({0.337512, 0.366634, 0.295854}));
      table->add(230, spec);
    }

    //----------------------------------------------------------------------
    // nu = 240 kl = 1.24446e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.46675, -5.45121, -5.50828}),
          BOOM::Vector({0.0581245, 0.0655099, 0.0576103}),
          BOOM::Vector({0.357846, 0.260403, 0.381751}));
      table->add(240, spec);
    }

    //----------------------------------------------------------------------
    // nu = 250 kl = 1.10843e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.49489, -5.5117, -5.55145}),
          BOOM::Vector({0.0643849, 0.0574723, 0.0561508}),
          BOOM::Vector({0.281086, 0.404865, 0.314049}));
      table->add(250, spec);
    }

    //----------------------------------------------------------------------
    // nu = 260 kl = 1.06821e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.54736, -5.5869, -5.53306}),
          BOOM::Vector({0.0559088, 0.0555146, 0.0629011}),
          BOOM::Vector({0.351194, 0.384028, 0.264778}));
      table->add(260, spec);
    }

    //----------------------------------------------------------------------
    // nu = 270 kl = 9.82957e-08
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.58563, -5.57163, -5.62419}),
          BOOM::Vector({0.0549545, 0.0617232, 0.0545329}),
          BOOM::Vector({0.353552, 0.266145, 0.380303}));
      table->add(270, spec);
    }

    //----------------------------------------------------------------------
    // nu = 280 kl = 9.23094e-08
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.62266, -5.6092, -5.66032}),
          BOOM::Vector({0.053995, 0.0606264, 0.0535643}),
          BOOM::Vector({0.353081, 0.274232, 0.372687}));
      table->add(280, spec);
    }

    //----------------------------------------------------------------------
    // nu = 290 kl = 8.52317e-08
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.65755, -5.64443, -5.69444}),
          BOOM::Vector({0.0530998, 0.0595201, 0.0527612}),
          BOOM::Vector({0.349126, 0.267992, 0.382882}));
      table->add(290, spec);
    }

    //----------------------------------------------------------------------
    // nu = 300 kl = 7.96444e-08
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.69289, -5.67987, -5.72881}),
          BOOM::Vector({0.0523339, 0.0585845, 0.0518024}),
          BOOM::Vector({0.360508, 0.28083, 0.358662}));
      table->add(300, spec);
    }

    //----------------------------------------------------------------------
    // nu = 310 kl = 8.08354e-08
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.71496, -5.7623, -5.72711}),
          BOOM::Vector({0.0577421, 0.0508107, 0.0514665}),
          BOOM::Vector({0.309271, 0.329713, 0.361016}));
      table->add(310, spec);
    }

    //----------------------------------------------------------------------
    // nu = 320 kl = 1.43765e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.7484, -5.78692, -5.76382}),
          BOOM::Vector({0.0565681, 0.0514662, 0.052778}),
          BOOM::Vector({0.330193, 0.347638, 0.322169}));
      table->add(320, spec);
    }

    //----------------------------------------------------------------------
    // nu = 330 kl = 6.81062e-08
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.82358, -5.77785, -5.78983}),
          BOOM::Vector({0.0494164, 0.0558944, 0.0500174}),
          BOOM::Vector({0.336304, 0.30051, 0.363186}));
      table->add(330, spec);
    }

    //----------------------------------------------------------------------
    // nu = 340 kl = 1.8947e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.81357, -5.82428, -5.84493}),
          BOOM::Vector({0.0553874, 0.0527019, 0.0497359}),
          BOOM::Vector({0.340129, 0.328777, 0.331095}));
      table->add(340, spec);
    }

    //----------------------------------------------------------------------
    // nu = 350 kl = 1.73371e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.87447, -5.84411, -5.85104}),
          BOOM::Vector({0.0488635, 0.0549994, 0.0517299}),
          BOOM::Vector({0.329648, 0.326049, 0.344303}));
      table->add(350, spec);
    }

    //----------------------------------------------------------------------
    // nu = 360 kl = 5.48547e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.86812, -5.90682, -5.88051}),
          BOOM::Vector({0.0534391, 0.0480549, 0.0491737}),
          BOOM::Vector({0.332741, 0.316517, 0.350742}));
      table->add(360, spec);
    }

    //----------------------------------------------------------------------
    // nu = 370 kl = 5.24499e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.93342, -5.8989, -5.90394}),
          BOOM::Vector({0.0471444, 0.0536591, 0.0482132}),
          BOOM::Vector({0.335083, 0.331522, 0.333395}));
      table->add(370, spec);
    }

    //----------------------------------------------------------------------
    // nu = 380 kl = 3.83564e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.92401, -5.93217, -5.95978}),
          BOOM::Vector({0.0522994, 0.0475936, 0.0467336}),
          BOOM::Vector({0.338216, 0.319657, 0.342127}));
      table->add(380, spec);
    }

    //----------------------------------------------------------------------
    // nu = 390 kl = 2.91623e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.94947, -5.98594, -5.95853}),
          BOOM::Vector({0.0515196, 0.0461259, 0.0469668}),
          BOOM::Vector({0.326952, 0.339115, 0.333934}));
      table->add(390, spec);
    }

    //----------------------------------------------------------------------
    // nu = 400 kl = 2.87646e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-5.97572, -6.01053, -5.98311}),
          BOOM::Vector({0.0510844, 0.0455741, 0.0465364}),
          BOOM::Vector({0.319196, 0.34517, 0.335634}));
      table->add(400, spec);
    }

    //----------------------------------------------------------------------
    // nu = 410 kl = 2.3746e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-6.00055, -6.0361, -6.00924}),
          BOOM::Vector({0.0502869, 0.0449224, 0.0458125}),
          BOOM::Vector({0.336518, 0.320943, 0.342539}));
      table->add(410, spec);
    }

    //----------------------------------------------------------------------
    // nu = 420 kl = 3.23533e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-6.02521, -6.03284, -6.05877}),
          BOOM::Vector({0.0497247, 0.0454366, 0.0445677}),
          BOOM::Vector({0.336312, 0.324744, 0.338944}));
      table->add(420, spec);
    }

    //----------------------------------------------------------------------
    // nu = 430 kl = 4.62787e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-6.04809, -6.08129, -6.05763}),
          BOOM::Vector({0.0488974, 0.0442975, 0.0452656}),
          BOOM::Vector({0.328012, 0.343151, 0.328837}));
      table->add(430, spec);
    }

    //----------------------------------------------------------------------
    // nu = 440 kl = 7.99345e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-6.07286, -6.10187, -6.08143}),
          BOOM::Vector({0.0485866, 0.0440253, 0.0457522}),
          BOOM::Vector({0.323268, 0.341412, 0.335319}));
      table->add(440, spec);
    }

    //----------------------------------------------------------------------
    // nu = 450 kl = 1.17342e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-6.10608, -6.0959, -6.12269}),
          BOOM::Vector({0.045962, 0.0479051, 0.0435974}),
          BOOM::Vector({0.337664, 0.333833, 0.328504}));
      table->add(450, spec);
    }

    //----------------------------------------------------------------------
    // nu = 460 kl = 1.24952e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-6.14397, -6.12911, -6.11746}),
          BOOM::Vector({0.04325, 0.0455266, 0.0472396}),
          BOOM::Vector({0.332096, 0.332746, 0.335158}));
      table->add(460, spec);
    }

    //----------------------------------------------------------------------
    // nu = 470 kl = 1.98255e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-6.13856, -6.17013, -6.14538}),
          BOOM::Vector({0.0470398, 0.042242, 0.0429249}),
          BOOM::Vector({0.326625, 0.344121, 0.329255}));
      table->add(470, spec);
    }

    //----------------------------------------------------------------------
    // nu = 480 kl = 8.94091e-07
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-6.15718, -6.18769, -6.1728}),
          BOOM::Vector({0.0456653, 0.04255, 0.0435675}),
          BOOM::Vector({0.328283, 0.340844, 0.330873}));
      table->add(480, spec);
    }

    //----------------------------------------------------------------------
    // nu = 490 kl = 7.93575e-08
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-6.18031, -6.1878, -6.21256}),
          BOOM::Vector({0.0459948, 0.041922, 0.0412468}),
          BOOM::Vector({0.327882, 0.347286, 0.324832}));
      table->add(490, spec);
    }

    //----------------------------------------------------------------------
    // nu = 500 kl = 1.15849e-06
    {
      NormalMixtureApproximation spec(
          BOOM::Vector({-6.19755, -6.22679, -6.21672}),
          BOOM::Vector({0.0445135, 0.0419629, 0.042726}),
          BOOM::Vector({0.33304, 0.324799, 0.342161}));
      table->add(500, spec);
    }
  }
}  // namespace BOOM
