% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BP_FitBayesianCompactness.R
\name{BP_FitBayesianCompactness}
\alias{BP_FitBayesianCompactness}
\title{Estimation of Bayesian model of a bone section}
\usage{
BP_FitBayesianCompactness(
  bone = stop("A result from BP_FitMLCompactness() must be provided"),
  priors = NULL,
  n.iter = 10000,
  n.chains = 1,
  n.adapt = 100,
  thin = 1,
  analysis = 1,
  silent = TRUE
)
}
\arguments{
\item{bone}{The bone image to be used}

\item{priors}{Priors}

\item{n.iter}{Number of iterations}

\item{n.chains}{Number of chains}

\item{n.adapt}{Number of iteration to adapt}

\item{thin}{Thin parameter for analysis}

\item{analysis}{Name or rank of analysis}

\item{silent}{Should some information must me shown ?}
}
\value{
The -Ln L
}
\description{
Estimation of Bayesian model of a bone section.
}
\details{
BP_FitBayesianCompactness estimates Bayesian model of a bone section
}
\examples{
\dontrun{
# Not run:
 library(BoneProfileR)
 path_Hedgehog <- system.file("extdata", "Erinaceus_europaeus_fem_2-1_small.png", 
                             package = "BoneProfileR")
 bone <- BP_OpenImage(file=path_Hedgehog)
 bone <- BP_DetectBackground(bone=bone, analysis="logistic")
 bone <- BP_DetectForeground(bone=bone, analysis="logistic")
 bone <- BP_DetectCenters(bone=bone, analysis="logistic")
 bone <- BP_EstimateCompactness(bone, analysis="logistic")
 bone <- BP_FitMLCompactness(bone, analysis="logistic")
 plot(bone)
 plot(bone, type="observations")
 plot(bone, type="observations+model", analysis=1)
 fittedpar <- BP_GetFittedParameters(bone, analysis="logistic")
 bone <- BP_DuplicateAnalysis(bone, from="logistic", to="flexit")
 bone <- BP_FitMLCompactness(bone, 
                fitted.parameters=c(fittedpar, K1=1, K2=1), 
                fixed.parameters=NULL, analysis="flexit")
 compare_AIC(Logistic=BP_GetFittedParameters(bone, analysis="logistic", alloptim=TRUE), 
             Flexit=BP_GetFittedParameters(bone, analysis="flexit", alloptim=TRUE))
 out4p <- plot(bone, type="observations+model", analysis="logistic")
 out6p <- plot(bone, type="observations+model", analysis="flexit")
 bone <- BP_FitBayesianCompactness(bone, analysis="logistic")
 plot(bone, type="observations+model", CI="MCMC", analysis="logistic")
 bone <- BP_FitBayesianCompactness(bone, analysis="flexit")
 plot(bone, type="observations+model", CI="MCMC", analysis="flexit")
}
}
\seealso{
Other BoneProfileR: 
\code{\link{BP_AutoFit}()},
\code{\link{BP_ChooseBackground}()},
\code{\link{BP_ChooseCenter}()},
\code{\link{BP_ChooseForeground}()},
\code{\link{BP_DetectBackground}()},
\code{\link{BP_DetectCenters}()},
\code{\link{BP_DetectForeground}()},
\code{\link{BP_DuplicateAnalysis}()},
\code{\link{BP_EstimateCompactness}()},
\code{\link{BP_FitMLCompactness}()},
\code{\link{BP_FitMLRadialCompactness}()},
\code{\link{BP_GetFittedParameters}()},
\code{\link{BP_ListAnalyses}()},
\code{\link{BP_LnLCompactness}()},
\code{\link{BP_OpenImage}()},
\code{\link{BP_Report}()},
\code{\link{Erinaceus_europaeus}},
\code{\link{plot.BoneProfileR}()},
\code{\link{summary.BoneProfileR}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{BoneProfileR}
