/*
 * Decompiled with CFR 0.152.
 */
package jebl.math;

import jebl.math.OrderEnumerator;

public interface OrthogonalHints {
    public OrderEnumerator getSuggestedOrdering(OrderEnumerator var1);

    public int getInternalParameterBoundaries(int var1, double[] var2);

    public static class Utils {
        private Utils() {
        }

        public static final OrthogonalHints getAdjusted(OrthogonalHints toAdjust, int adjustmentFactor) {
            return new Adjusted(toAdjust, adjustmentFactor);
        }

        public static final OrthogonalHints getCombined(OrthogonalHints first, int numberOfFirstParameters, OrthogonalHints second, int numberOfSecondParameters) {
            return new Combined(first, numberOfFirstParameters, second, numberOfSecondParameters);
        }

        public static final double[] getInternalParameterBoundaries(OrthogonalHints base, int parameter) {
            double[] store = new double[100];
            int numberReturned = base.getInternalParameterBoundaries(parameter, store);
            while (numberReturned < 0) {
                store = new double[store.length + 10];
                numberReturned = base.getInternalParameterBoundaries(parameter, store);
            }
            double[] result = new double[numberReturned];
            System.arraycopy(store, 0, result, 0, numberReturned);
            return result;
        }

        public static final OrthogonalHints getNull() {
            return Null.INSTANCE;
        }

        private static final class Combined
        implements OrthogonalHints {
            OrthogonalHints hintsOne_;
            OrthogonalHints hintsTwo_;
            int hintOneParameterCount_;
            int hintTwoParameterCount_;

            public Combined(OrthogonalHints hintsOne, int hintOneParameterCount, OrthogonalHints hintsTwo, int hintTwoParameterCount) {
                this.hintsOne_ = hintsOne;
                this.hintOneParameterCount_ = hintOneParameterCount;
                this.hintTwoParameterCount_ = hintTwoParameterCount;
                this.hintsTwo_ = hintsTwo;
            }

            public OrderEnumerator getSuggestedOrdering(OrderEnumerator defaultOrdering) {
                OrderEnumerator oe1 = this.hintsOne_.getSuggestedOrdering(null);
                OrderEnumerator oe2 = this.hintsTwo_.getSuggestedOrdering(null);
                if (oe1 == null && oe2 == null) {
                    return defaultOrdering;
                }
                if (oe1 == null && oe2 != null) {
                    if (defaultOrdering != null) {
                        return OrderEnumerator.Utils.getAlternating(OrderEnumerator.Utils.getRestricted(defaultOrdering, 0, this.hintOneParameterCount_), OrderEnumerator.Utils.getAdjusted(oe2, this.hintOneParameterCount_));
                    }
                    return OrderEnumerator.Utils.getAlternating(OrderEnumerator.Utils.getShuffled(this.hintOneParameterCount_), OrderEnumerator.Utils.getAdjusted(oe2, this.hintOneParameterCount_));
                }
                if (oe2 == null) {
                    if (defaultOrdering != null) {
                        return OrderEnumerator.Utils.getAlternating(oe1, OrderEnumerator.Utils.getRestricted(defaultOrdering, this.hintOneParameterCount_, this.hintOneParameterCount_ + this.hintTwoParameterCount_));
                    }
                    return OrderEnumerator.Utils.getAlternating(oe1, OrderEnumerator.Utils.getAdjusted(OrderEnumerator.Utils.getShuffled(this.hintTwoParameterCount_), this.hintOneParameterCount_));
                }
                return OrderEnumerator.Utils.getAlternating(oe1, OrderEnumerator.Utils.getAdjusted(oe2, this.hintOneParameterCount_));
            }

            public int getInternalParameterBoundaries(int parameter, double[] storage) {
                if (parameter < this.hintOneParameterCount_) {
                    return this.hintsOne_.getInternalParameterBoundaries(parameter, storage);
                }
                return this.hintsTwo_.getInternalParameterBoundaries(parameter - this.hintOneParameterCount_, storage);
            }
        }

        private static final class Null
        implements OrthogonalHints {
            public static final Null INSTANCE = new Null();

            public OrderEnumerator getSuggestedOrdering(OrderEnumerator defaultOrdering) {
                return defaultOrdering;
            }

            public int getInternalParameterBoundaries(int parameter, double[] storage) {
                return 0;
            }
        }

        private static final class Adjusted
        implements OrthogonalHints {
            OrthogonalHints toAdjust_;
            int adjustmentFactor_;

            public Adjusted(OrthogonalHints toAdjust, int adjustmentFactor) {
                this.toAdjust_ = toAdjust;
                this.adjustmentFactor_ = adjustmentFactor;
            }

            public OrderEnumerator getSuggestedOrdering(OrderEnumerator defaultOrdering) {
                OrderEnumerator sub = this.toAdjust_.getSuggestedOrdering(defaultOrdering);
                if (sub == null || sub == defaultOrdering) {
                    return defaultOrdering;
                }
                return OrderEnumerator.Utils.getAdjusted(sub, this.adjustmentFactor_);
            }

            public int getInternalParameterBoundaries(int parameter, double[] storage) {
                return this.toAdjust_.getInternalParameterBoundaries(parameter - this.adjustmentFactor_, storage);
            }
        }
    }
}

