/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.mcmcmc;

import dr.inference.markovchain.MarkovChain;
import dr.inference.mcmcmc.ParallelTempering;
import dr.inference.operators.OperatorSchedule;

public class MCMCMCOptions {
    private final double[] temperatures;
    private final int swapChainsEvery;
    private final SwapScheme swapScheme;

    public MCMCMCOptions(double[] dArray, int n, SwapScheme swapScheme) {
        this.temperatures = dArray;
        this.swapChainsEvery = n;
        this.swapScheme = swapScheme;
    }

    public double[] getChainTemperatures() {
        return this.temperatures;
    }

    public int getSwapChainsEvery() {
        return this.swapChainsEvery;
    }

    public SwapScheme getSwapScheme() {
        return this.swapScheme;
    }

    public static enum SwapScheme {
        ORIGINAL_FLAVOR("original"){

            @Override
            public ParallelTempering factory(MarkovChain[] markovChainArray, OperatorSchedule[] operatorScheduleArray, MCMCMCOptions mCMCMCOptions) {
                return new ParallelTempering.OriginalFlavor(markovChainArray, operatorScheduleArray, mCMCMCOptions);
            }
        }
        ,
        STOCHASTIC_SINGLE("stochastic_single"){

            @Override
            public ParallelTempering factory(MarkovChain[] markovChainArray, OperatorSchedule[] operatorScheduleArray, MCMCMCOptions mCMCMCOptions) {
                return new ParallelTempering.StochasticSingleSwap(markovChainArray, operatorScheduleArray, mCMCMCOptions);
            }
        }
        ,
        STOCHASTIC_MULTIPLE("stochastic_multiple"){

            @Override
            public ParallelTempering factory(MarkovChain[] markovChainArray, OperatorSchedule[] operatorScheduleArray, MCMCMCOptions mCMCMCOptions) {
                return new ParallelTempering.StochasticMultipleSwap(markovChainArray, operatorScheduleArray, mCMCMCOptions);
            }
        }
        ,
        DETERMINISTIC_SINGLE("deterministic_single"){

            @Override
            public ParallelTempering factory(MarkovChain[] markovChainArray, OperatorSchedule[] operatorScheduleArray, MCMCMCOptions mCMCMCOptions) {
                return new ParallelTempering.DeterministicSingleSwap(markovChainArray, operatorScheduleArray, mCMCMCOptions);
            }
        }
        ,
        DETERMINISTIC_MULTIPLE("deterministic_multiple"){

            @Override
            public ParallelTempering factory(MarkovChain[] markovChainArray, OperatorSchedule[] operatorScheduleArray, MCMCMCOptions mCMCMCOptions) {
                return new ParallelTempering.DeterministicMultipleSwap(markovChainArray, operatorScheduleArray, mCMCMCOptions);
            }
        };

        private final String name;

        private SwapScheme(String string2) {
            this.name = string2;
        }

        public static SwapScheme parse(String string) {
            for (SwapScheme swapScheme : SwapScheme.values()) {
                if (!swapScheme.name.equalsIgnoreCase(string)) continue;
                return swapScheme;
            }
            throw new RuntimeException("Unknown swap scheme '" + string + "'");
        }

        public abstract ParallelTempering factory(MarkovChain[] var1, OperatorSchedule[] var2, MCMCMCOptions var3);
    }
}

