/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.model.GradientProvider;
import dr.math.NumericalDerivative;
import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;

public class SkewTDistribution
extends AbstractContinuousDistribution
implements GradientProvider,
Distribution,
Citable {
    private final double location;
    private final double scale;
    private final double shape;
    private final double df;
    public static Citation CITATION = new Citation(new Author[]{new Author("RD", "Wilkingson"), new Author("ME", "Steiper"), new Author("C", "Soligo"), new Author("RD", "Martin"), new Author("Z", "Yang"), new Author("S", "Tavar\u00e9")}, "Dating Primate Divergences through an Integrated Analysis of Palaeontological and Molecular Data", 2011, "Systematic Biology", 60, 16, 31, Citation.Status.PUBLISHED);
    private final UnivariateFunction logPdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double d) {
            return SkewTDistribution.this.logPdf(d);
        }

        @Override
        public final double getLowerBound() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public final double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };

    public SkewTDistribution(double d, double d2, double d3, double d4) {
        this.location = d;
        this.scale = d2;
        this.shape = d3;
        this.df = d4;
    }

    @Override
    public double pdf(double d) {
        double d2 = (d - this.location) / this.scale;
        double d3 = this.LnGamma(this.df / 2.0);
        double d4 = this.LnGamma((this.df + 1.0) / 2.0);
        double d5 = d4 - d3 - 0.5 * Math.log(Math.PI * this.df);
        double d6 = d4 + 0.5723649429247001 - d3 - Math.log(this.df / 2.0);
        double d7 = 2.0 / this.scale * this.PDFt(d2, 0.0, 1.0, this.df, d5) * this.CDFt(this.shape * d2 * Math.sqrt((this.df + 1.0) / (this.df + d2 * d2)), 0.0, 1.0, this.df + 1.0, d6);
        return d7;
    }

    private double LnGamma(double d) {
        double d2;
        assert (d > 0.0);
        double d3 = 0.0;
        double d4 = 0.0;
        int n = (int)d;
        if ((double)n == d && n >= 0 && n <= 11) {
            d2 = Math.log(this.factorial(n - 1));
        } else {
            double d5;
            if (d <= 0.0) {
                throw new RuntimeException("Undefined negative value for Gamma function.");
            }
            if (d < 7.0) {
                d3 = 1.0;
                d5 = d - 1.0;
                while (true) {
                    double d6;
                    d5 += 1.0;
                    if (!(d6 < 7.0)) break;
                    d3 *= d5;
                }
                d = d5;
                d3 = -Math.log(d3);
            }
            d5 = 1.0 / (d * d);
            d2 = d4 + d3 + (d - 0.5) * Math.log(d) - d + 0.918938533204673 + (((-5.95238095238E-4 * d5 + 7.93650793651E-4) * d5 - 0.002777777777778) * d5 + 0.083333333333333) / d;
        }
        return d2;
    }

    private double factorial(int n) {
        long l = 1L;
        if (n > 11) {
            throw new RuntimeException("n>10 in factorial");
        }
        for (long i = 2L; i <= (long)n; ++i) {
            l *= i;
        }
        return l;
    }

    private double PDFt(double d, double d2, double d3, double d4, double d5) {
        double d6 = (d - d2) / d3;
        double d7 = d5;
        if (d7 == 0.0) {
            d7 = this.LnGamma((d4 + 1.0) / 2.0) - this.LnGamma(d4 / 2.0) - 0.5 * Math.log(Math.PI * d4);
        }
        return Math.exp(d7 -= (d4 + 1.0) / 2.0 * Math.log(1.0 + d6 * d6 / d4)) / d3;
    }

    private double CDFt(double d, double d2, double d3, double d4, double d5) {
        double d6 = (d - d2) / d3;
        double d7 = 0.5723649429247001;
        if (d5 == 0.0) {
            d5 = this.LnGamma(d4 / 2.0) + d7 - this.LnGamma((d4 + 1.0) / 2.0);
        }
        double d8 = this.CDFBeta(d4 / (d4 + d6 * d6), d4 / 2.0, 0.5, d5);
        d8 = d6 >= 0.0 ? 1.0 - d8 / 2.0 : (d8 /= 2.0);
        return d8;
    }

    private double CDFBeta(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = 1.0E-15;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        if (d < d6) {
            return 0.0;
        }
        if (d > 1.0 - d6) {
            return 1.0;
        }
        if (d2 <= 0.0 || d3 <= 0.0) {
            throw new RuntimeException("pin qin parameter outside range in CDFBeta");
        }
        if (d7 == 0.0) {
            d7 = Math.pow(2.0, -53.0);
            d8 = Math.log(d7);
            d9 = Double.MIN_VALUE;
            d10 = Math.log(d9);
        }
        double d11 = d;
        double d12 = d2;
        double d13 = d3;
        if (d12 / (d12 + d13) < d) {
            d11 = 1.0 - d11;
            d12 = d3;
            d13 = d2;
        }
        if (d4 == 0.0) {
            d4 = this.LnBeta(d12, d13);
        }
        if ((d12 + d13) * d11 / (d12 + 1.0) < d7) {
            d5 = 0.0;
            double d14 = d12 * Math.log(Math.max(d11, d9)) - Math.log(d12) - d4;
            if (d14 > d10 && d11 != 0.0) {
                d5 = Math.exp(d14);
            }
            if (d11 != d || d12 != d2) {
                d5 = 1.0 - d5;
            }
        } else {
            double d15;
            int n;
            int n2;
            double d16;
            double d17 = d13 - Math.floor(d13);
            if (d17 == 0.0) {
                d17 = 1.0;
            }
            double d18 = this.LnGamma(d17) + this.LnGamma(d12) - this.LnGamma(d17 + d12);
            d18 = d12 * Math.log(d11) - d18 - Math.log(d12);
            d5 = 0.0;
            if (d18 >= d10) {
                d5 = Math.exp(d18);
                d16 = d5 * d12;
                if (d17 != 1.0) {
                    n2 = (int)Math.max(d8 / Math.log(d11), 4.0);
                    for (n = 1; n <= n2; ++n) {
                        d15 = n;
                        d16 = d16 * (d15 - d17) * d11 / d15;
                        d5 += d16 / (d12 + d15);
                    }
                }
            }
            if (d13 > 1.0) {
                d18 = d12 * Math.log(d11) + d13 * Math.log(1.0 - d11) - d4 - Math.log(d13);
                int n3 = (int)(d18 / d10);
                if (n3 < 0) {
                    n3 = 0;
                }
                d16 = Math.exp(d18 - (double)n3 * d10);
                double d19 = 1.0 / (1.0 - d11);
                double d20 = d13 * d19 / (d12 + d13 - 1.0);
                double d21 = 0.0;
                n2 = (int)d13;
                if (d13 == (double)n2) {
                    --n2;
                }
                for (n = 1; !(n > n2 || d20 <= 1.0 && d16 / d7 <= d21); ++n) {
                    d15 = n;
                    if ((d16 = (d13 - d15 + 1.0) * d19 * d16 / (d12 + d13 - d15)) > 1.0) {
                        --n3;
                        d16 *= d9;
                    }
                    if (n3 != 0) continue;
                    d21 += d16;
                }
                d5 += d21;
            }
            if (d11 != d || d12 != d2) {
                d5 = 1.0 - d5;
            }
            if (d5 > 1.0) {
                d5 = 1.0;
            }
            if (d5 < 0.0) {
                d5 = 0.0;
            }
        }
        return d5;
    }

    private double LnBeta(double d, double d2) {
        return this.LnGamma(d) + this.LnGamma(d2) - this.LnGamma(d + d2);
    }

    @Override
    public double logPdf(double d) {
        return Math.log(this.pdf(d));
    }

    @Override
    public double cdf(double d) {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    public double quantile(double d) {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    public double mean() {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    public double variance() {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    public UnivariateFunction getProbabilityDensityFunction() {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    protected double getInitialDomain(double d) {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    protected double getDomainLowerBound(double d) {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    protected double getDomainUpperBound(double d) {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    public double cumulativeProbability(double d) throws MathException {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.PRIOR_MODELS;
    }

    @Override
    public String getDescription() {
        return "Skew-T distribution.";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        return new double[]{NumericalDerivative.firstDerivative(this.logPdfFunction, (Double)object)};
    }
}

