/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.continuous;

import dr.evolution.tree.Tree;
import dr.evomodel.treedatalikelihood.continuous.ContinuousTraitPartialsProvider;
import dr.math.matrixAlgebra.Vector;
import java.util.Arrays;

public class PartiallyMissingInformation {
    private final int tipCount;
    private final int numTraits;
    private final int dimTrait;
    private final boolean[] rawMissingIndicators;
    private final boolean[] anyMissing;
    private final boolean[] allMissing;
    private final HashedIntArray[] missingIndices;

    public PartiallyMissingInformation(Tree tree, ContinuousTraitPartialsProvider continuousTraitPartialsProvider) {
        this.tipCount = tree.getExternalNodeCount();
        this.numTraits = continuousTraitPartialsProvider.getTraitCount();
        this.dimTrait = continuousTraitPartialsProvider.getTraitDimension();
        this.rawMissingIndicators = continuousTraitPartialsProvider.getTraitMissingIndicators();
        int n = this.tipCount * this.numTraits;
        this.anyMissing = new boolean[n];
        this.allMissing = new boolean[n];
        this.missingIndices = new HashedIntArray[n];
        this.setupIndices();
    }

    public boolean isPartiallyMissing(int n, int n2) {
        return this.anyMissing[this.getIndex(n, n2)];
    }

    public boolean isCompletelyMissing(int n, int n2) {
        return this.allMissing[this.getIndex(n, n2)];
    }

    public HashedIntArray getMissingIndices(int n, int n2) {
        return this.missingIndices[this.getIndex(n, n2)];
    }

    private void setupIndices() {
        for (int i = 0; i < this.tipCount; ++i) {
            for (int j = 0; j < this.numTraits; ++j) {
                int n = this.getIndex(i, j);
                int n2 = 0;
                for (int k = 0; k < this.dimTrait; ++k) {
                    if (!this.isObservationMissing(n, k)) continue;
                    ++n2;
                }
                if (n2 > 0) {
                    int[] nArray = new int[n2];
                    int[] nArray2 = new int[this.dimTrait - n2];
                    int n3 = 0;
                    int n4 = 0;
                    for (int k = 0; k < this.dimTrait; ++k) {
                        if (this.isObservationMissing(n, k)) {
                            nArray[n3] = k;
                            ++n3;
                            continue;
                        }
                        nArray2[n4] = k;
                        ++n4;
                    }
                    this.anyMissing[n] = true;
                    this.missingIndices[n] = new HashedIntArray(nArray, nArray2);
                    if (n2 != this.dimTrait) continue;
                    this.allMissing[n] = true;
                    continue;
                }
                this.anyMissing[n] = false;
                this.allMissing[n] = false;
                this.missingIndices[n] = null;
            }
        }
    }

    private int getIndex(int n, int n2) {
        return n * this.numTraits + n2;
    }

    private boolean isObservationMissing(int n, int n2) {
        if (this.rawMissingIndicators == null) {
            return false;
        }
        int n3 = n * this.dimTrait + n2;
        return this.rawMissingIndicators[n3];
    }

    public class HashedIntArray {
        private final int[] array;
        private final int[] complement;

        HashedIntArray(int[] nArray, int[] nArray2) {
            this.array = nArray;
            this.complement = nArray2;
        }

        public int[] getArray() {
            return this.array;
        }

        public int[] getComplement() {
            return this.complement;
        }

        public int get(int n) {
            return this.array[n];
        }

        public int getLength() {
            return this.array.length;
        }

        public int hashCode() {
            return Arrays.hashCode(this.array);
        }

        public boolean equals(Object object) {
            return object instanceof int[] && Arrays.equals(this.array, (int[])object);
        }

        public String toString() {
            return new Vector(this.array).toString();
        }
    }
}

