/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evomodel.continuous.LatentTruncation;
import dr.inference.distribution.AbstractDistributionLikelihood;
import dr.inference.distribution.DistributionLikelihood;
import dr.inference.model.Statistic;
import dr.math.distributions.NormalDistribution;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class TruncatedWorkingDistribution
extends AbstractDistributionLikelihood {
    public static final String MEAN = "mean";
    public static final String STDEV = "stdev";
    public static final String WORKING_PRIOR = "truncatedWorkingPrior";
    private DistributionLikelihood baseDistribution;
    private LatentTruncation truncation;
    public static XMLObjectParser WORKING_PRIOR_PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("mean"), AttributeRule.newDoubleRule("stdev"), new ElementRule(Statistic.class, 1, Integer.MAX_VALUE), new ElementRule(LatentTruncation.class)};

        @Override
        public String getParserName() {
            return TruncatedWorkingDistribution.WORKING_PRIOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute(TruncatedWorkingDistribution.MEAN);
            double d2 = xMLObject.getDoubleAttribute(TruncatedWorkingDistribution.STDEV);
            DistributionLikelihood distributionLikelihood = new DistributionLikelihood(new NormalDistribution(d, d2));
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                if (xMLObject.getChild(i) instanceof Statistic) {
                    distributionLikelihood.addData((Statistic)xMLObject.getChild(i));
                    continue;
                }
                if (xMLObject.getChild(i) instanceof LatentTruncation) continue;
                throw new XMLParseException("Illegal element in " + xMLObject.getName() + " element");
            }
            LatentTruncation latentTruncation = (LatentTruncation)xMLObject.getChild(LatentTruncation.class);
            return new TruncatedWorkingDistribution(distributionLikelihood, latentTruncation);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Calculates the prior probability of some data under a latent truncated normal distribution.";
        }

        @Override
        public Class getReturnType() {
            return TruncatedWorkingDistribution.class;
        }
    };

    public TruncatedWorkingDistribution(DistributionLikelihood distributionLikelihood, LatentTruncation latentTruncation) {
        super(distributionLikelihood.getModel());
        this.baseDistribution = distributionLikelihood;
        this.truncation = latentTruncation;
    }

    @Override
    public double calculateLogLikelihood() {
        double d = this.truncation.getLogLikelihood();
        if (d != Double.NEGATIVE_INFINITY) {
            d += this.baseDistribution.getLogLikelihood() + this.truncation.getNormalizationConstant(this.baseDistribution.getDistribution());
        }
        return d;
    }
}

