/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.operators;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.coalescent.GaussianProcessSkytrackLikelihood;
import dr.evomodel.coalescent.operators.GaussianProcessSkytrackBlockUpdateOperator;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;
import dr.util.ComparableDouble;
import dr.util.HeapSort;
import java.util.ArrayList;
import no.uib.cipr.matrix.DenseVector;

public class GaussianProcessSkytrackTreeOperator
extends AbstractAdaptableOperator {
    private TreeModel tree = null;
    private double scaleFactor;
    private Parameter popSizeParameter;
    private Parameter changePoints;
    private Parameter CoalCounts;
    private Parameter GPtype;
    private Parameter coalfactor;
    private Parameter precisionParameter;
    private Parameter lambdaParameter;
    private GaussianProcessSkytrackBlockUpdateOperator GPOperator = new GaussianProcessSkytrackBlockUpdateOperator();
    GaussianProcessSkytrackLikelihood gpLikelihood;
    private double[] zeros;

    public GaussianProcessSkytrackTreeOperator(TreeModel treeModel, GaussianProcessSkytrackLikelihood gaussianProcessSkytrackLikelihood, double d, double d2, AdaptationMode adaptationMode) {
        super(adaptationMode);
        this.tree = treeModel;
        this.gpLikelihood = gaussianProcessSkytrackLikelihood;
        this.popSizeParameter = gaussianProcessSkytrackLikelihood.getPopSizeParameter();
        this.changePoints = gaussianProcessSkytrackLikelihood.getChangePoints();
        this.GPtype = gaussianProcessSkytrackLikelihood.getGPtype();
        this.CoalCounts = gaussianProcessSkytrackLikelihood.getCoalCounts();
        this.coalfactor = gaussianProcessSkytrackLikelihood.getcoalfactor();
        this.precisionParameter = gaussianProcessSkytrackLikelihood.getPrecisionParameter();
        this.scaleFactor = d2;
        this.setWeight(d);
    }

    private static void collectAllTimes(Tree tree, NodeRef nodeRef, NodeRef[] nodeRefArray, ArrayList<ComparableDouble> arrayList, ArrayList<Integer> arrayList2) {
        arrayList.add(new ComparableDouble(tree.getNodeHeight(nodeRef)));
        arrayList2.add(tree.getChildCount(nodeRef));
        for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef2 = tree.getChild(nodeRef, i);
            if (nodeRefArray == null) {
                GaussianProcessSkytrackTreeOperator.collectAllTimes(tree, nodeRef2, nodeRefArray, arrayList, arrayList2);
                continue;
            }
            boolean bl = true;
            for (NodeRef nodeRef3 : nodeRefArray) {
                if (nodeRef3.getNumber() != nodeRef2.getNumber()) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            GaussianProcessSkytrackTreeOperator.collectAllTimes(tree, nodeRef2, nodeRefArray, arrayList, arrayList2);
        }
    }

    public Trip1GP getTreeIntervals(Tree tree, NodeRef nodeRef, NodeRef[] nodeRefArray) {
        int n = tree.getNodeCount();
        double[] dArray = new double[n];
        int[] nArray = new int[n];
        double d = 1.0E-9;
        ArrayList<ComparableDouble> arrayList = new ArrayList<ComparableDouble>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        GaussianProcessSkytrackTreeOperator.collectAllTimes(tree, nodeRef, nodeRefArray, arrayList, arrayList2);
        int[] nArray2 = new int[arrayList.size()];
        HeapSort.sort(arrayList, nArray2);
        double d2 = arrayList.get(nArray2[0]).doubleValue();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n3 < arrayList.size()) {
            double d3;
            int n5 = 0;
            int n6 = 0;
            double d4 = d3 = arrayList.get(nArray2[n3]).doubleValue();
            while (Math.abs(d4 - d3) < d) {
                int n7 = arrayList2.get(nArray2[n3]);
                if (n7 == 0) {
                    ++n6;
                } else {
                    n5 += n7 - 1;
                }
                if (++n3 == arrayList.size()) break;
                d4 = arrayList.get(nArray2[n3]).doubleValue();
            }
            if (n6 > 0) {
                if (n4 > 0 || d3 - d2 > d) {
                    dArray[n4] = d3 - d2;
                    nArray[n4] = n2;
                    ++n4;
                }
                d2 = d3;
            }
            n2 += n6;
            if (n5 > 0) {
                dArray[n4] = d3 - d2;
                nArray[n4] = n2;
                ++n4;
                d2 = d3;
            }
            n2 -= n5;
        }
        int n8 = n4;
        return new Trip1GP(dArray, nArray, n8);
    }

    private double[] getoldCoalTimes(int n) {
        double[] dArray = new double[n];
        int n2 = 0;
        for (int i = 0; i < this.changePoints.getSize(); ++i) {
            if (this.GPtype.getParameterValue(i) != 1.0) continue;
            dArray[n2] = this.changePoints.getParameterValue(i);
            ++n2;
        }
        return dArray;
    }

    private int wherePoint(double d, double[] dArray) {
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(d < (d3 += dArray[i]) & d > d2)) continue;
            n = i;
            break;
        }
        return n;
    }

    private TripGP getNewCoalTimes(double[] dArray, int n, int[] nArray) {
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        int n2 = 0;
        int n3 = 0;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i];
            n3 = this.getEventType(i, n, nArray);
            if (n3 <= 0) continue;
            dArray2[n2] = d;
            dArray3[n2] = (double)nArray[i] * ((double)nArray[i] - 1.0) / 2.0;
            ++n2;
        }
        return new TripGP(dArray2, dArray3, n2);
    }

    private final int getEventType(int n, int n2, int[] nArray) {
        if (n >= n2) {
            throw new IllegalArgumentException();
        }
        if (n < n2 - 1) {
            return nArray[n] - nArray[n + 1];
        }
        return nArray[n] - 1;
    }

    @Override
    public double doOperation() {
        double d;
        int n;
        int n2;
        double d2 = 0.0;
        Trip1GP trip1GP = this.getTreeIntervals(this.tree, this.tree.getRoot(), null);
        double[] dArray = trip1GP.getInterval();
        int[] nArray = trip1GP.getLineages();
        int n3 = trip1GP.getnIntervals();
        boolean bl = false;
        int n4 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        int n5 = this.changePoints.getSize();
        TripGP tripGP = this.getNewCoalTimes(dArray, n3, nArray);
        double[] dArray2 = tripGP.getTimes();
        double[] dArray3 = tripGP.getFactor();
        double[] dArray4 = this.getoldCoalTimes(tripGP.getnIntervals());
        System.err.println("Makes GP proposal for coalescent times");
        bl = this.changePoints.getParameterValue(this.changePoints.getSize() - 1) != dArray2[tripGP.getnIntervals() - 1];
        if (!bl) {
            n2 = 0;
            for (n = 0; n < this.changePoints.getSize(); ++n) {
                DenseVector denseVector;
                double[] dArray5;
                if (this.GPtype.getParameterValue(n) != 1.0) continue;
                n2 = 0;
                if (this.changePoints.getParameterValue(n) != dArray2[n4]) {
                    if (this.changePoints.getParameterValue(n) < dArray2[n4] & n4 <= tripGP.getnIntervals() - 1) {
                        n2 = 1;
                    }
                    if (this.changePoints.getParameterValue(n) > dArray2[n4]) {
                        n2 = 2;
                    }
                }
                if (n2 == 1) {
                    dArray5 = this.changePoints.getParameterValues();
                    denseVector = new DenseVector(this.popSizeParameter.getParameterValues());
                    d = this.precisionParameter.getParameterValue(0);
                    d2 += this.GPOperator.getDensity(dArray5, denseVector, this.changePoints.getParameterValue(n), d, n);
                    this.changePoints.removeDimension(n + 1);
                    this.GPtype.removeDimension(n + 1);
                    this.popSizeParameter.removeDimension(n + 1);
                    this.coalfactor.removeDimension(n + 1);
                    --n;
                    --n4;
                }
                if (n2 == 2) {
                    dArray5 = this.changePoints.getParameterValues();
                    denseVector = new DenseVector(this.popSizeParameter.getParameterValues());
                    d = this.precisionParameter.getParameterValue(0);
                    double[] dArray6 = this.GPOperator.getGPvalue(dArray5, denseVector, dArray2[n4], d);
                    this.popSizeParameter.addDimension((int)dArray6[2], dArray6[0]);
                    this.changePoints.addDimension((int)dArray6[2], dArray2[n4]);
                    this.GPtype.addDimension((int)dArray6[2], 1.0);
                    this.coalfactor.addDimension((int)dArray6[2], dArray3[n4]);
                    n = (int)dArray6[2];
                    d2 -= dArray6[1];
                }
                if (++n4 == tripGP.getnIntervals()) break;
            }
        }
        if (bl) {
            n2 = 0;
            n = 0;
            int n6 = 0;
            int n7 = 0;
            d = 0.0;
            double d3 = dArray4[n2];
            double d4 = 0.0;
            double d5 = dArray2[n2];
            int n8 = 0;
            System.err.println("size before" + this.changePoints.getSize());
            for (int i = 0; i < this.changePoints.getSize(); ++i) {
                double[] dArray7;
                double d6;
                DenseVector denseVector;
                double[] dArray8;
                n8 = 0;
                if (this.changePoints.getParameterValue(i) < d5 & i < this.changePoints.getSize() - 1) {
                    if (this.GPtype.getParameterValue(i) == -1.0) {
                        if (this.changePoints.getParameterValue(i) > Math.max(d, d4) & this.changePoints.getParameterValue(i) < Math.min(d3, d5)) {
                            ++n7;
                        } else {
                            n8 = 1;
                        }
                    } else {
                        n8 = 1;
                    }
                }
                if (this.changePoints.getParameterValue(i) < d5 & i == this.changePoints.getSize() - 1) {
                    n8 = 2;
                }
                if (this.changePoints.getParameterValue(i) >= d5) {
                    if ((double)n7 < this.CoalCounts.getParameterValue(n2)) {
                        n8 = 3;
                    } else {
                        if (this.changePoints.getParameterValue(i) > d5 & n2 < tripGP.getnIntervals() - 1) {
                            n8 = 4;
                        }
                        if (this.changePoints.getParameterValue(i) == d5 & n2 < tripGP.getnIntervals() - 1) {
                            n8 = 5;
                        }
                        if (this.changePoints.getParameterValue(i) == d5 & n2 == tripGP.getnIntervals() - 1) {
                            if (i < this.changePoints.getSize() - 1) {
                                n8 = 7;
                            }
                            if (i == this.changePoints.getSize() - 1) break;
                        }
                        if (this.changePoints.getParameterValue(i) > d5 & n2 == tripGP.getnIntervals() - 1) {
                            n8 = 6;
                        }
                    }
                }
                if (n8 == 1) {
                    dArray8 = this.changePoints.getParameterValues();
                    denseVector = new DenseVector(this.popSizeParameter.getParameterValues());
                    d6 = this.precisionParameter.getParameterValue(0);
                    d2 += this.GPOperator.getDensity(dArray8, denseVector, this.changePoints.getParameterValue(i), d6, i);
                    d2 -= Math.log(d3 - d);
                    this.changePoints.removeDimension(i + 1);
                    this.GPtype.removeDimension(i + 1);
                    this.popSizeParameter.removeDimension(i + 1);
                    this.coalfactor.removeDimension(i + 1);
                    --i;
                }
                if (n8 == 2) {
                    dArray8 = this.changePoints.getParameterValues();
                    denseVector = new DenseVector(this.popSizeParameter.getParameterValues());
                    d6 = this.precisionParameter.getParameterValue(0);
                    d2 += this.GPOperator.getDensity(dArray8, denseVector, this.changePoints.getParameterValue(i), d6, i);
                    dArray7 = this.GPOperator.getGPvalueroot(dArray8, denseVector, d5, d6);
                    this.popSizeParameter.setParameterValue(i, dArray7[0]);
                    this.changePoints.setParameterValue(i, d5);
                    this.coalfactor.setParameterValue(i, dArray3[n2 - 1]);
                    d2 -= dArray7[1];
                    --i;
                }
                if (n8 == 3) {
                    int n9 = (int)this.CoalCounts.getParameterValue(n2) - n7;
                    i = i + (int)this.CoalCounts.getParameterValue(n2) - n7 - 1;
                    for (int j = 0; j < n9; ++j) {
                        double d7 = MathUtils.uniform(d4, d5);
                        n = this.wherePoint(d7, dArray);
                        double[] dArray9 = this.changePoints.getParameterValues();
                        DenseVector denseVector2 = new DenseVector(this.popSizeParameter.getParameterValues());
                        double d8 = this.precisionParameter.getParameterValue(0);
                        double[] dArray10 = this.GPOperator.getGPvalue(dArray9, denseVector2, d7, d8);
                        this.popSizeParameter.addDimension((int)dArray10[2], dArray10[0]);
                        this.changePoints.addDimension((int)dArray10[2], d7);
                        this.GPtype.addDimension((int)dArray10[2], -1.0);
                        this.coalfactor.addDimension((int)dArray10[2], 0.5 * (double)nArray[n] * (double)(nArray[n] - 1));
                        d2 -= dArray10[1];
                        d2 += Math.log(d5 - d4);
                        ++n7;
                    }
                }
                if (n8 == 4) {
                    double[] dArray11 = this.changePoints.getParameterValues();
                    DenseVector denseVector3 = new DenseVector(this.popSizeParameter.getParameterValues());
                    d6 = this.precisionParameter.getParameterValue(0);
                    dArray7 = this.GPOperator.getGPvalue(dArray11, denseVector3, d5, d6);
                    this.popSizeParameter.addDimension((int)dArray7[2], dArray7[0]);
                    this.changePoints.addDimension((int)dArray7[2], d5);
                    this.GPtype.addDimension((int)dArray7[2], 1.0);
                    this.coalfactor.addDimension((int)dArray7[2], dArray3[n2]);
                    d2 -= dArray7[1];
                    n7 = 0;
                    n6 = n;
                    d4 = d5;
                    d = d3;
                    d5 = dArray2[++n2];
                    d3 = dArray4[n2];
                }
                if (n8 == 5) {
                    n7 = 0;
                    n6 = n;
                    d4 = d5;
                    d = d3;
                    d5 = dArray2[++n2];
                    d3 = dArray4[n2];
                    double[] dArray12 = this.changePoints.getParameterValues();
                    DenseVector denseVector4 = new DenseVector(this.popSizeParameter.getParameterValues());
                    d6 = this.precisionParameter.getParameterValue(0);
                    if (i == this.changePoints.getSize() - 1) {
                        dArray7 = this.GPOperator.getGPvalueroot(dArray12, denseVector4, d5, d6);
                        this.popSizeParameter.addDimension(i + 1, dArray7[0]);
                        this.changePoints.addDimension(i + 1, d5);
                        this.GPtype.addDimension(i + 1, 1.0);
                        this.coalfactor.addDimension(i + 1, dArray3[n2]);
                        d2 -= dArray7[1];
                    }
                }
                if (n8 == 6) {
                    double[] dArray13 = this.changePoints.getParameterValues();
                    DenseVector denseVector5 = new DenseVector(this.popSizeParameter.getParameterValues());
                    d6 = this.precisionParameter.getParameterValue(0);
                    dArray7 = this.GPOperator.getGPvalue(dArray13, denseVector5, d5, d6);
                    this.popSizeParameter.addDimension(i, dArray7[0]);
                    this.changePoints.addDimension(i, d5);
                    this.GPtype.addDimension(i, 1.0);
                    this.coalfactor.addDimension(i, dArray3[n2]);
                    d2 -= dArray7[1];
                    --i;
                }
                if (n8 != 7) continue;
                double[] dArray14 = this.changePoints.getParameterValues();
                DenseVector denseVector6 = new DenseVector(this.popSizeParameter.getParameterValues());
                d6 = this.precisionParameter.getParameterValue(0);
                d2 += this.GPOperator.getDensity(dArray14, denseVector6, this.changePoints.getParameterValue(i + 1), d6, i + 1);
                d2 -= Math.log(d3 - d);
                if (i < this.changePoints.getSize() - 2) {
                    this.changePoints.removeDimension(i + 2);
                    this.GPtype.removeDimension(i + 2);
                    this.popSizeParameter.removeDimension(i + 2);
                    this.coalfactor.removeDimension(i + 2);
                } else {
                    this.changePoints.setDimension(i + 1);
                    this.GPtype.setDimension(i + 1);
                    this.popSizeParameter.setDimension(i + 1);
                    this.coalfactor.setDimension(i + 1);
                }
                --i;
            }
        }
        System.err.println("size after" + this.changePoints.getSize() + "and ratio" + d2);
        return d2;
    }

    @Override
    public final String getOperatorName() {
        return "gpTreeOperator";
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.sqrt(this.scaleFactor - 1.0);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.scaleFactor = 1.0 + d * d;
    }

    @Override
    public double getRawParameter() {
        return this.scaleFactor;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public String getAdaptableParameterName() {
        return "scaleFactor";
    }

    private class TripGP {
        private double[] array1;
        private double[] array2;
        private int array3;

        public TripGP(double[] dArray, double[] dArray2, int n) {
            this.array1 = dArray;
            this.array2 = dArray2;
            this.array3 = n;
        }

        public double[] getTimes() {
            return this.array1;
        }

        public double[] getFactor() {
            return this.array2;
        }

        public int getnIntervals() {
            return this.array3;
        }
    }

    private class Trip1GP {
        private double[] array1;
        private int[] array2;
        private int array3;

        public Trip1GP(double[] dArray, int[] nArray, int n) {
            this.array1 = dArray;
            this.array2 = nArray;
            this.array3 = n;
        }

        public double[] getInterval() {
            return this.array1;
        }

        public int[] getLineages() {
            return this.array2;
        }

        public int getnIntervals() {
            return this.array3;
        }
    }
}

