/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.arg;

import dr.evomodel.arg.ARGDistinctTreeCountStatistic;
import dr.evomodel.arg.ARGModel;
import dr.evoxml.util.GraphMLUtils;
import dr.inference.loggers.LogFormatter;
import dr.inference.loggers.MCLogger;
import dr.inference.loggers.MLLogger;
import dr.inference.loggers.TabDelimitedFormatter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.logging.Logger;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ARGLogger
extends MCLogger {
    public static final String LOG_ARG = "logArg";
    public static final String DOT_FORMAT = "dotFormat";
    public static final String COMPRESSED_STRING = "compressedString";
    public static final String EXTENDED_NEWICK = "extendedNewick";
    public static final String STRIPPED_NEWICK = "strippedNewick";
    public static final String FULL_STRING = "fullString";
    public static final String DISTINCT_TREES = "distinctTrees";
    public static final String FORMAT = "format";
    public static final String LOG = "log";
    public static final String ECHO = "echo";
    public static final String ECHO_EVERY = "echoEvery";
    public static final String TITLE = "title";
    public static final String FILE_NAME = "fileName";
    public static final String TAB = "tab";
    public static final String HTML = "html";
    public static final String PRETTY = "pretty";
    public static final String LOG_EVERY = "logEvery";
    public static final String COLUMNS = "columns";
    public static final String COLUMN = "column";
    public static final String LABEL = "label";
    public static final String SIGNIFICANT_FIGURES = "sf";
    public static final String DECIMAL_PLACES = "dp";
    public static final String WIDTH = "width";
    private ARGModel argModel;
    private String formatType;
    private ARGDistinctTreeCountStatistic treeStat;
    public static final String GRAPHML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd\">";
    public static final String GRAPHML_FOOTER = "</graphml>";
    static XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        String[] validFormats = new String[]{"dotFormat", "extendedNewick", "compressedString", "fullString", "strippedNewick", "distinctTrees"};
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newIntegerRule("logEvery"), new StringAttributeRule("format", "The type logger's output type", this.validFormats, false), new StringAttributeRule("fileName", "The name of the file to send log output to. If no file name is specified then log is sent to standard output", true), new StringAttributeRule("title", "The title of the log", true), new ElementRule(ARGModel.class, "The ARG which is to be logged")};

        @Override
        public String getParserName() {
            return ARGLogger.LOG_ARG;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            PrintWriter printWriter;
            Object object;
            Object object2;
            ARGModel aRGModel = (ARGModel)xMLObject.getChild(ARGModel.class);
            String string = null;
            String string2 = null;
            String string3 = null;
            if (xMLObject.hasAttribute(ARGLogger.TITLE)) {
                string2 = xMLObject.getStringAttribute(ARGLogger.TITLE);
            }
            if (xMLObject.hasAttribute(ARGLogger.FILE_NAME)) {
                string = xMLObject.getStringAttribute(ARGLogger.FILE_NAME);
            }
            if (xMLObject.hasAttribute(ARGLogger.FORMAT)) {
                string3 = xMLObject.getStringAttribute(ARGLogger.FORMAT);
            }
            int n = 1;
            if (xMLObject.hasAttribute(ARGLogger.LOG_EVERY)) {
                n = xMLObject.getIntegerAttribute(ARGLogger.LOG_EVERY);
            }
            if (string != null) {
                try {
                    object2 = new File(string);
                    object = ((File)object2).getName();
                    String string4 = ((File)object2).getParent();
                    if (!((File)object2).isAbsolute()) {
                        string4 = System.getProperty("user.dir");
                    }
                    printWriter = new PrintWriter(new FileOutputStream(new File(string4, (String)object)));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new XMLParseException("File '" + string + "' can not be opened for " + this.getParserName() + " element.");
                }
            } else {
                printWriter = new PrintWriter(System.out);
            }
            object2 = new TabDelimitedFormatter(printWriter);
            Logger.getLogger("dr.evomodel").info("Creating logArg of type " + string3);
            object = new ARGLogger(aRGModel, (LogFormatter)object2, n, string3);
            if (string2 != null) {
                ((MCLogger)object).setTitle(string2);
            }
            return object;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Logs an ARG to a file";
        }

        @Override
        public String getExample() {
            return "<!-- The " + this.getParserName() + " element takes an argModel to be logged -->\n<" + this.getParserName() + " " + ARGLogger.LOG_EVERY + "=\"100\" " + ARGLogger.FILE_NAME + "=\"log.args\">\n\t<argModel idref=\"treeModel1\"/>\n</" + this.getParserName() + ">\n";
        }

        @Override
        public Class getReturnType() {
            return MLLogger.class;
        }
    };

    public ARGLogger(ARGModel aRGModel, LogFormatter logFormatter, int n, String string) {
        super(logFormatter, n, false);
        this.argModel = aRGModel;
        this.formatType = string;
        if (string.equals(DISTINCT_TREES)) {
            this.treeStat = new ARGDistinctTreeCountStatistic(aRGModel);
        }
    }

    @Override
    public void startLogging() {
        if (this.formatType.equals(EXTENDED_NEWICK)) {
            this.logLine("stateARG.string");
        } else if (this.formatType.equals(STRIPPED_NEWICK)) {
            this.logLine("StrippedARGString");
        } else {
            this.logLine(GRAPHML_HEADER);
        }
    }

    @Override
    public void stopLogging() {
        if (!this.formatType.equals(EXTENDED_NEWICK) && !this.formatType.equals(STRIPPED_NEWICK)) {
            this.logLine(GRAPHML_FOOTER);
        }
    }

    @Override
    public void log(long l) {
        if (this.logEvery <= 0L || l % this.logEvery == 0L) {
            Element element = this.argModel.toXML();
            element.setAttribute("id", "STATE_" + l);
            if (this.formatType.equals(DOT_FORMAT)) {
                this.logLine(GraphMLUtils.dotFormat(element));
            } else if (this.formatType.equals(COMPRESSED_STRING)) {
                this.logLine("ARG STATE_" + l + " = " + this.argModel.toGraphStringCompressed(false));
            } else if (this.formatType.equals(FULL_STRING)) {
                this.logLine(outputter.outputString(element));
            } else if (this.formatType.equals(EXTENDED_NEWICK)) {
                this.logLine(this.argModel.toExtendedNewick());
            } else if (this.formatType.equals(DISTINCT_TREES)) {
                this.logLine(this.treeStat.getStatisticValue(0) + "\t" + this.treeStat.getFullOutput());
            } else {
                this.logLine(this.argModel.toStrippedNewick());
            }
        }
    }
}

