/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.colouring;

import dr.evolution.colouring.BranchColouring;
import dr.evolution.colouring.DefaultBranchColouring;
import dr.evolution.colouring.TreeColouring;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;

public class DefaultTreeColouring
implements TreeColouring {
    private final Tree tree;
    private final int colourCount;
    private final DefaultBranchColouring[] branchColourings;
    private int colourChangeCount;
    private double logP = Double.NEGATIVE_INFINITY;
    private boolean immutable = false;
    private boolean hasProbability = false;

    public DefaultTreeColouring(int n, Tree tree) {
        this.colourCount = n;
        this.tree = tree;
        this.branchColourings = new DefaultBranchColouring[tree.getNodeCount()];
        this.colourChangeCount = 0;
    }

    public DefaultTreeColouring(DefaultTreeColouring defaultTreeColouring) {
        if (!defaultTreeColouring.immutable) {
            throw new RuntimeException("Attempted to create a copy of a mutable colouring");
        }
        this.colourCount = defaultTreeColouring.colourCount;
        this.tree = defaultTreeColouring.tree;
        this.colourChangeCount = defaultTreeColouring.colourChangeCount;
        this.branchColourings = (DefaultBranchColouring[])defaultTreeColouring.branchColourings.clone();
        for (int i = 0; i < this.branchColourings.length; ++i) {
            this.branchColourings[i] = this.branchColourings[i].getCopy();
        }
    }

    @Override
    public int getColourCount() {
        return this.colourCount;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    public void setBranchColouring(NodeRef nodeRef, DefaultBranchColouring defaultBranchColouring) {
        if (this.immutable) {
            throw new RuntimeException("Attempted to setBranchColouring of an immutable colouring");
        }
        if (this.tree.isRoot(nodeRef)) {
            throw new IllegalArgumentException("Can't set a BranchColouring for the root node");
        }
        if (this.branchColourings[nodeRef.getNumber()] != null) {
            this.colourChangeCount -= this.branchColourings[nodeRef.getNumber()].getColourChanges().size();
        }
        this.branchColourings[nodeRef.getNumber()] = defaultBranchColouring;
        this.colourChangeCount += defaultBranchColouring.getColourChanges().size();
    }

    @Override
    public void setLogProbabilityDensity(double d) {
        if (this.hasProbability) {
            throw new RuntimeException("Attempted to set probability twice");
        }
        this.makeImmutable();
        this.hasProbability = true;
        this.logP = d;
    }

    public void makeImmutable() {
        this.immutable = true;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    @Override
    public boolean hasProbability() {
        return this.hasProbability;
    }

    public void checkColouring() {
        this.checkColouringAtNode(this.tree.getRoot());
    }

    private void checkColouringAtNode(NodeRef nodeRef) {
        int n = this.getNodeColour(nodeRef);
        if (!this.tree.isExternal(nodeRef)) {
            for (int i = 0; i < this.tree.getChildCount(nodeRef); ++i) {
                NodeRef nodeRef2 = this.tree.getChild(nodeRef, i);
                if (this.branchColourings[nodeRef2.getNumber()].getParentColour() != n) {
                    throw new RuntimeException("Colour mismatch at node " + nodeRef.toString());
                }
                this.checkColouringAtNode(nodeRef2);
            }
        }
    }

    @Override
    public int getNodeColour(NodeRef nodeRef) {
        if (this.tree.isRoot(nodeRef)) {
            NodeRef nodeRef2 = this.tree.getChild(nodeRef, 0);
            return this.branchColourings[nodeRef2.getNumber()].getParentColour();
        }
        return this.branchColourings[nodeRef.getNumber()].getChildColour();
    }

    @Override
    public BranchColouring getBranchColouring(NodeRef nodeRef) {
        return this.branchColourings[nodeRef.getNumber()];
    }

    @Override
    public int getColourChangeCount() {
        return this.colourChangeCount;
    }

    public double getLogProbabilityDensity() {
        if (!this.hasProbability) {
            throw new RuntimeException("Tree colouring has no probability density; use colouringModel.getTreeColouringWithProbability()");
        }
        return this.logP;
    }
}

