% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap_hp.R
\name{Heatmap.HP}
\alias{Heatmap.HP}
\title{HP: Heatmap for the life expectancy}
\usage{
\method{Heatmap}{HP}(
  x,
  x_lab = NULL,
  age = 0:90,
  max_age = 110,
  color = c("red", "white", "blue"),
  ...
)
}
\arguments{
\item{x}{Object or a list of objects of the class \code{HP} or \code{ClosedHP} returned by hp() or close_hp() functions.}

\item{x_lab}{Description of the object 'fit'.}

\item{age}{Vector with the ages to plot the heatmap.}

\item{max_age}{Positive number indicating the last age to be considered to compute the life expectancy (extrapolation will be considered to match the age interval if needed). This argument is only necessary with objects of the class \code{HP}.}

\item{color}{Vector of colours used in the heatmap.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A ggplot2 heatmap of the life expectancy.
}
\description{
This function plots a heatmap for the life expectancy of the fitted HP models.
}
\examples{
## Importing mortality data from the USA available on the Human Mortality Database (HMD):
data(USA)

# Example: -------------------------------

USA2010 = USA[USA$Year == 2010,]

ExF = USA2010$Ex.Female[1:91]
DxF = USA2010$Dx.Female[1:91]
x <- 0:90

fitF <- hp(x, ExF, DxF, model = "lognormal", M = 1000, bn = 0, thin = 10)

Heatmap(fitF, x_lab = "Female expec. 2010 USA")

}
\seealso{
\code{\link[=Heatmap.BLC]{Heatmap.BLC()}} and \code{\link[=Heatmap.DLM]{Heatmap.DLM()}} for \code{BLC} or \code{DLM} methods.

\code{\link[=Heatmap.list]{Heatmap.list()}} to the \code{list} method, adding multiple objects in one single Heatmap.
}
