% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.MDSmap.R
\name{is.MDSmap}
\alias{is.MDSmap}
\title{Reports whether x is a 'MDSmap' object}
\usage{
is.MDSmap(x)
}
\arguments{
\item{x}{an object to test.}
}
\value{
Returns TRUE if its argument is of class \code{MDSmap} and FALSE otherwise.
}
\description{
Reports whether x is a 'MDSmap' object
}
\examples{
data <- subset(Pbox, MIN >= 1500)
data <- data.frame(data$PTS, data$P3M, data$P2M, data$OREB + data$DREB, data$AST,
                   data$TOV,data$STL, data$BLK)
mds <- MDSmap(data)
is.MDSmap(mds)
}
\references{
P. Zuccolotto and M. Manisera (2020) Basketball Data Science: With Applications in R. CRC Press.
}
\seealso{
\code{\link{MDSmap}}
}
\author{
Marco Sandri, Paola Zuccolotto, Marica Manisera (\email{basketballanalyzer.help@unibs.it})
}
