% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inequality.R
\name{inequality}
\alias{inequality}
\title{Inequality analysis}
\usage{
inequality(data, nplayers)
}
\arguments{
\item{data}{numeric vector containing the achievements (e.g. scored points) of the players whose inequality has to be analyzed.}

\item{nplayers}{integer, number of players to include in the analysis (ranked in nondecreasing order according to the values in data).}
}
\value{
A list with the following elements: \code{Lorenz} (cumulative distributions used to plot the Lorenz curve) and \code{Gini} (Gini coefficient).
}
\description{
Inequality analysis
}
\examples{
Pbox.BN <- subset(Pbox, Team=="Brooklyn Nets")
out <- inequality(Pbox.BN$PTS, nplayers=8)
print(out)
plot(out)
}
\references{
P. Zuccolotto and M. Manisera (2020) Basketball Data Science: With Applications in R. CRC Press.
}
\seealso{
\code{\link{plot.inequality}}
}
\author{
Marco Sandri, Paola Zuccolotto, Marica Manisera (\email{basketballanalyzer.help@unibs.it})
}
