% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{tree.zero}
\alias{tree.zero}
\title{Convert negative branches of tree.}
\usage{
tree.zero(tree)
}
\arguments{
\item{tree}{A phylo object.}
}
\value{
A phylo object.
}
\description{
Converts negative branch lengths of any tree to zero.
}
\details{
Converts branches with negative values to zero while shortening only the two branches immediately below it by the same absolute amount to ensure the tree remains with tips at same distances and there are no polytomies.
}
\examples{
par(mfrow = c(1,2))
tree <- ape::read.tree(text='(((A:3, B:3):1,
(G:6, (H:5, I:5):1):-2):3, ((C:1, D:1):2, (E:4, F:4):-1):4);')
plot(tree)

tree = tree.zero(tree)
plot(tree)
}
