% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbi.R
\name{dbReadTable,AzureKustoConnection,character-method}
\alias{dbReadTable,AzureKustoConnection,character-method}
\alias{dbWriteTable,AzureKustoConnection,ANY-method}
\alias{dbCreateTable,AzureKustoConnection-method}
\alias{dbRemoveTable,AzureKustoConnection,ANY-method}
\alias{dbListTables,AzureKustoConnection-method}
\alias{dbExistsTable,AzureKustoConnection,ANY-method}
\title{DBI methods for Kusto table management}
\usage{
\S4method{dbReadTable}{AzureKustoConnection,character}(conn, name, ...)

\S4method{dbWriteTable}{AzureKustoConnection,ANY}(conn, name, value, method, ...)

\S4method{dbCreateTable}{AzureKustoConnection}(conn, name, fields, ..., row.names = NULL, temporary = FALSE)

\S4method{dbRemoveTable}{AzureKustoConnection,ANY}(conn, name, ...)

\S4method{dbListTables}{AzureKustoConnection}(conn, ...)

\S4method{dbExistsTable}{AzureKustoConnection,ANY}(conn, name, ...)
}
\arguments{
\item{conn}{An AzureKustoConnection object.}

\item{name}{A string containing a table name.}

\item{...}{Further arguments passed to \code{run_query}.}

\item{value}{For \code{dbWriteTable}, a data frame to be written to a Kusto table.}

\item{method}{For \code{dbWriteTable}, the ingestion method to use to write the table. See \link{ingest_local}.}

\item{fields}{For \code{dbCreateTable}, the table specification: either a named character vector, or a data frame of sample values.}

\item{row.names}{For \code{dbCreateTable}, the row names. Not used.}

\item{temporary}{For \code{dbCreateTable}, whether to create a temporary table. Must be \code{FALSE} for Kusto.}
}
\value{
For \code{dbReadTable}, an in-memory data frame containing the table.
}
\description{
DBI methods for Kusto table management
}
\details{
These functions read, write, create and delete a table, list the tables in a Kusto database, and check for table existence. With the exception of \code{dbWriteTable}, they ultimately call \code{run_query} which does the actual work of communicating with the Kusto server. \code{dbWriteTable} calls \code{ingest_local} to write the data to the server; note that it only supports ingesting a local data frame, as per the DBI spec.

Kusto does not have the concept of temporary tables, so calling \code{dbCreateTable} with \code{temporary} set to anything other than \code{FALSE} will generate an error.

\code{dbReadTable} and \code{dbWriteTable} are likely to be of limited use in practical scenarios, since Kusto tables tend to be much larger than available memory.
}
\examples{
\dontrun{
db <- DBI::dbConnect(AzureKusto(),
    server="https://mycluster.location.kusto.windows.net", database="database"...)

DBI::dbListTables(db)

if(!DBI::dbExistsTable(db, "mtcars"))
    DBI::dbCreateTable(db, "mtcars")

DBI::dbWriteTable(db, "mtcars", mtcars, method="inline")

DBI::dbReadTable(db, "mtcars")

DBI::dbRemoveTable(db, "mtcars")

}
}
\seealso{
\link{AzureKusto-connection}, \link{dbConnect}, \link{run_query}, \link{ingest_local}
}
