% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degreesOfFreedom.R
\name{numNumFittedDf}
\alias{numNumFittedDf}
\alias{numNumSimpleDf}
\alias{numNumGammaShape}
\alias{numNumGammaScale}
\alias{facNumSimpleDf}
\alias{facNumFittedDf}
\alias{facNumGammaShape}
\alias{facNumGammaScale}
\title{Computing a binning's degrees of freedom}
\usage{
numNumFittedDf(nbins)

numNumSimpleDf(nbins)

numNumGammaShape(nbins)

numNumGammaScale(nbins)

facNumSimpleDf(nbins, ncat)

facNumFittedDf(nbins, ncat)

facNumGammaShape(nbins, ncat)

facNumGammaScale(nbins, ncat)
}
\arguments{
\item{nbins}{the number of bins resulting from recursive random
binning}

\item{ncat}{if one variable is categorical, the number of
values the variable can take}
}
\value{
A numeric estimate of the paramter. In the case of
degrees of freedom, this is generally not an integer.
}
\description{
Functions which compute the degrees of freedom of a
binning for a chi-squared approximation or parameters for
a gamma approximation based on empirical results.
}
\details{
These exported functions are used to compute parameters
needed to approximate the distribution of the chi-squared
statistic computed over bins. A full discussion can be found in
the accompanying paper.
}
\section{Functions}{
\itemize{
\item \code{numNumFittedDf()}: Dual continuous fitted df

\item \code{numNumSimpleDf()}: Dual continuous simple df

\item \code{numNumGammaShape()}: Dual continuous gamma shape

\item \code{numNumGammaScale()}: Dual continuous gamma scale

\item \code{facNumSimpleDf()}: Mixed type simple df

\item \code{facNumFittedDf()}: Mixed type fitted df

\item \code{facNumGammaShape()}: Mixed type gamma shape

\item \code{facNumGammaScale()}: Mixed type gamma scale

}}
\author{
Chris Salahub
}
