% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/duration.R
\docType{methods}
\name{duration}
\alias{duration}
\alias{duration-method}
\alias{duration,numeric,numeric-method}
\alias{duration,PhasesMCMC,missing-method}
\title{Phase Duration}
\usage{
duration(x, y, ...)

\S4method{duration}{numeric,numeric}(x, y)

\S4method{duration}{PhasesMCMC,missing}(x)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, \code{x} must be an
\code{\linkS4class{PhasesMCMC}} object.}

\item{...}{Currently not used.}
}
\description{
Phase Duration
}
\examples{
## Coerce to phases
pha <- as_phases(mcmc_phases, start = c(1, 3), calendar = CE(), iteration = 1)

## Compute phase duration
dur <- duration(pha)
summary(dur)
}
\seealso{
Other phase tools: 
\code{\link{phases}()}
}
\author{
A. Philippe, M.-A. Vibet, N. Frerebeau
}
\concept{phase tools}
