% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScheffeTest.R
\name{ScheffeTest}
\alias{ScheffeTest}
\title{Scheffé Test for Multiple Comparisons}
\usage{
ScheffeTest(modelo, alpha = 0.05)
}
\arguments{
\item{modelo}{An object of class \code{aov} or \code{lm} representing an ANOVA model.}

\item{alpha}{Significance level (default is 0.05).}
}
\value{
An object of class \code{"scheffe"} and \code{"comparaciones"}, containing:
\itemize{
  \item \code{Resultados}: A data frame of pairwise comparisons with difference, critical value, p-value, and significance code.
  \item \code{Promedios}: A named numeric vector of group means.
  \item \code{Orden_Medias}: A character vector with group names ordered from highest to lowest mean.
  \item \code{Metodo}: A character string indicating the test name ("Scheffe").
}
}
\description{
Performs Scheffé's post hoc test after fitting an ANOVA model. This test compares all possible
pairs of group means, using a critical value based on the F-distribution.
}
\details{
The Scheffé test is a conservative method, making it harder to detect significant differences,
but reducing the likelihood of Type I errors (false positives). It is especially appropriate
when the comparisons were not pre-planned and the number of contrasts is large.

Assumptions: normally distributed residuals and homogeneity of variances.

Advantages:
- Very robust to violations of assumptions.
- Suitable for complex comparisons, not just pairwise.

Disadvantages:
- Very conservative; reduced power.
- Not ideal for detecting small differences.
}
\examples{
data(d_e, package = "Analitica")
mod <- aov(Sueldo_actual ~ as.factor(labor), data = d_e)
resultado <- ScheffeTest(mod)
summary(resultado)
plot(resultado)
}
\references{
Scheffé, H. (1953). "A method for judging all contrasts in the analysis of variance." \emph{Biometrika}, 40(1/2), 87–104. <https://doi.org/10.1093/biomet/40.1-2.87>
}
