% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kinship_heatmap.R
\name{kinship.heatmap}
\alias{kinship.heatmap}
\title{Enhanced heatmap plot for a kinship matrix K}
\usage{
kinship.heatmap(
  K = NULL,
  dendrogram = TRUE,
  clustering.method = c("hierarchical", "kmeans"),
  dist.method = c("euclidean", "maximum", "manhattan", "canberra", "binary", "minkowski"),
  row.label = TRUE,
  col.label = FALSE
)
}
\arguments{
\item{K}{Input of a kinship matrix in full format (\eqn{n \times n}) (default = \code{NULL}).}

\item{dendrogram}{If \code{TRUE} a dendrogram is added to the columns based on the
kinship matrix (default = \code{TRUE}).}

\item{clustering.method}{The clustering method considered for the dendrogram.
Options are: \code{"hierarchical"} and \code{"kmeans"} (default = \code{"hierarchical"}).}

\item{dist.method}{The method considered to calculate the distance matrix between
individuals used for hierarchical clustering. Options are: \code{"euclidean"},
\code{"maximum"}, \code{"manhattan"}, \code{"canberra"}, \code{"binary"} and
\code{"minkowski"} (default = \code{"euclidean"}).}

\item{row.label}{If \code{TRUE} the individual names (\code{rownames}) are added as labels to
the left of the heatmap (default = \code{TRUE}).}

\item{col.label}{If \code{TRUE} the individual names (\code{colnames}) are added as labels to
the bottom of the heatmap (default = \code{FALSE}).}
}
\value{
A plot with the properties specified by the above arguments.
}
\description{
Generates a heatmap with dendrogram based on a provided kinship matrix.
This matrix can be a pedigree relationship matrix \eqn{\boldsymbol{A}}, a
genomic relationship matrix \eqn{\boldsymbol{G}} or a hybrid relationship
matrix \eqn{\boldsymbol{H}}.
Individual names should be assigned to \code{rownames} and \code{colnames}.
It sorts individuals according to dendrogram in both columns and rows.
}
\details{
Uses the library \code{superheat} from Barter and Yu (2018) to generate plots.
}
\examples{
# Get G matrix.
G <- G.matrix(M = geno.apple, method = "VanRaden")$G
G[1:5, 1:5]

# Plot a subset of the individuals.
kinship.heatmap(K = G[1:10, 1:10], dendrogram = TRUE, row.label = TRUE, col.label = TRUE)

}
\references{
Barter, R.L. and Yu, B. 2018. Superheat: An R package for creating beautiful
and extendable heatmaps for visualizing complex data.
J. Comput. Graph. Stat. 27(4):910-922.
}
