% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AHPtools.R
\name{AHPweights}
\alias{AHPweights}
\title{Compute weights for Alternatives and lowest level sub criteria in AHP responses}
\usage{
AHPweights(ExcelPath, AHPsheet, PCMsheet)
}
\arguments{
\item{ExcelPath}{for the Excel file containing the AHP structure and the required PCMs}

\item{AHPsheet}{for the AHP structure, with three required columns, viz.
Column 1: Node:             the node names for all nodes that have child nodes 
Column 2: Parent:           the parent node for the Node in Column 1
Column 3: Children_Ordered: the child nodes for the Node in Column 1.
                            these are comma separated strings, and correspond to the
                            ordered upper triangular elements of the PCM in Sheet 2}

\item{PCMsheet}{for the PCMs that are part of the AHP. The upper triangular matrix elements
are provided for each PCM, so that a nxn PCM has n(n-1)/2 entries.
These entries have column names starting with the AHP node name with
respect to which the child elements are being compared, followed by a 
dot (.) and a sequence of numbers from 1 to n(n-1)/2 for the PCM elements}
}
\value{
A list of two items,
(i)  AHPtree     which is a printable tree object constructed from the user-provided AHP structure
(ii) AHPresult   the list of weights for the lowest level subcriteria, and weights of alternatives 
                 if exists
}
\description{
This function reads an Excel file with two required Sheets, viz. 
Sheet 1:  for the AHP structure, with three columns as follows:
Sheet 2:  for the upper triangular elements of the PCMs that are part of the AHP hierarchy                          

This returns a list of two values:
 (1) a printable AHP tree excluding the alternatives, if any
 (2) the list of weights for the lowest level subcriteria, and weights of alternatives 
           if exists
}
\details{
For an overview and examples, please see the associated vignette:
`vignette("AHPweights", package = "AHPtools")`
}
\examples{
file <- system.file("extdata", "example_transport.xlsx", package = "AHPtools")
results <- AHPweights(file, "ahp", "pcm")
print(results)
}
