% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_diagflat}
\alias{torch_diagflat}
\title{Diagflat}
\usage{
torch_diagflat(self, offset = 0L)
}
\arguments{
\item{self}{(Tensor) the input tensor.}

\item{offset}{(int, optional) the diagonal to consider. Default: 0 (main        diagonal).}
}
\description{
Diagflat
}
\section{diagflat(input, offset=0) -> Tensor }{

\itemize{
\item If \code{input} is a vector (1-D tensor), then returns a 2-D square tensor
with the elements of \code{input} as the diagonal.
\item If \code{input} is a tensor with more than one dimension, then returns a
2-D tensor with diagonal elements equal to a flattened \code{input}.
}

The argument \code{offset} controls which diagonal to consider:
\itemize{
\item If \code{offset} = 0, it is the main diagonal.
\item If \code{offset} > 0, it is above the main diagonal.
\item If \code{offset} < 0, it is below the main diagonal.
}
}

\examples{
if (torch_is_installed()) {

a = torch_randn(c(3))
a
torch_diagflat(a)
torch_diagflat(a, 1)
a = torch_randn(c(2, 2))
a
torch_diagflat(a)
}
}
