% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iet.R
\name{iet_carlson}
\alias{iet_carlson}
\title{Trophic State Index (Carlson)}
\usage{
iet_carlson(secchi = NULL, clorofila = NULL, tp = NULL, .keep_ids = FALSE)
}
\arguments{
\item{secchi}{Numeric vector with Secchi depth (m) \strong{or} a data.frame
containing columns named \code{secchi} (m), \code{clorofila} (ug/L) and
\code{tp} (ug/L) or \code{p_total} (mg/L). If a data.frame is provided,
\code{clorofila} and \code{tp} must be \code{NULL}.}

\item{clorofila}{Numeric vector with chlorophyll-a (ug/L).}

\item{tp}{Numeric vector with total phosphorus (ug/L).}

\item{.keep_ids}{Logical; when a data.frame is provided, bind back common
ID columns (\code{rio}, \code{ponto}, \code{data}, \code{lat}, \code{lon}).
Default \code{FALSE} (keeps historical behaviour).}
}
\value{
A data frame with columns (when applicable):
\itemize{
\item \code{TSI_Secchi} — component from Secchi depth.
\item \code{TSI_Chla} — component from chlorophyll-a.
\item \code{TSI_TP} — component from total phosphorus.
\item \code{IET} — overall Carlson index (row mean).
}
}
\description{
Computes Carlson's Trophic State Index (TSI/IET) from Secchi depth,
chlorophyll-a, and total phosphorus. Returns component scores and the
overall IET as the row-wise mean of available components.

You can also pass a data.frame as the first argument (see Details).
}
\details{
Implemented component formulas (Carlson 1977):
\itemize{
\item \code{TSI_Secchi = 60 - 14.41 * log10(secchi)}
\item \code{TSI_Chla  = 9.81 * log10(clorofila) + 30.6}
\item \code{TSI_TP    = 14.42 * log10(tp) + 4.15}
}

When a data.frame is provided, character inputs using comma decimal (e.g. "3,2")
or inequality symbols (e.g. "<0,1") are safely converted to numeric. If
\code{p_total} (mg/L) exists instead of \code{tp} (ug/L), it is converted
internally (\code{tp = p_total * 1000}).

Inputs may contain \code{NA} and are recycled according to R rules.
The overall index \code{IET} is the row mean of the available components
(\code{na.rm = TRUE}).
}
\examples{
# Vector usage (kept as-is)
secchi <- c(1.2, 0.8, 0.4)        # m
clorofila <- c(5, 12, 30)         # ug/L
tp <- c(20, 40, 70)               # ug/L
iet_carlson(secchi = secchi, clorofila = clorofila, tp = tp)

# Data frame usage (optional)
# df <- data.frame(secchi = secchi, clorofila = clorofila, p_total = c(0.02, 0.04, 0.07))
# iet_carlson(df)                  # auto-converts p_total (mg/L) to tp (ug/L)
# iet_carlson(df, .keep_ids = TRUE)

}
\references{
Carlson, R. E. (1977). \emph{A trophic state index for lakes}.
Limnology and Oceanography, 22(2), 361–369.
doi:10.4319/lo.1977.22.2.0361
}
\seealso{
\code{\link[=iet_lamparelli]{iet_lamparelli()}}, \code{\link[=iqa]{iqa()}}, \code{\link[=conama_check]{conama_check()}}
}
