% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ee_manage.R
\name{ee_manage-tools}
\alias{ee_manage-tools}
\alias{ee_manage_create}
\alias{ee_manage_delete}
\alias{ee_manage_assetlist}
\alias{ee_manage_quota}
\alias{ee_manage_copy}
\alias{ee_manage_move}
\alias{ee_manage_set_properties}
\alias{ee_manage_delete_properties}
\alias{ee_manage_asset_access}
\alias{ee_manage_task}
\alias{ee_manage_cancel_all_running_task}
\alias{ee_manage_asset_size}
\title{Interface to manage the Earth Engine Asset}
\usage{
ee_manage_create(path_asset, asset_type = "Folder", quiet = FALSE)

ee_manage_delete(path_asset, quiet = FALSE, strict = TRUE)

ee_manage_assetlist(path_asset, quiet = FALSE, strict = TRUE)

ee_manage_quota(quiet = FALSE)

ee_manage_copy(path_asset, final_path, strict = TRUE, quiet = FALSE)

ee_manage_move(path_asset, final_path, strict = TRUE, quiet = FALSE)

ee_manage_set_properties(path_asset, add_properties, strict = TRUE)

ee_manage_delete_properties(path_asset, del_properties = "ALL", strict = TRUE)

ee_manage_asset_access(
  path_asset,
  owner = NULL,
  editor = NULL,
  viewer = NULL,
  all_users_can_read = TRUE,
  quiet = FALSE
)

ee_manage_task(cache = FALSE)

ee_manage_cancel_all_running_task()

ee_manage_asset_size(path_asset, quiet = FALSE)
}
\arguments{
\item{path_asset}{Character. Name of the EE asset (Table, Image, Folder or
ImageCollection).}

\item{asset_type}{Character. The asset type to create ('Folder' or
'ImageCollection').}

\item{quiet}{Logical. Suppress info message.}

\item{strict}{Character vector. If TRUE, the existence of the asset will be
evaluated before performing the task.}

\item{final_path}{Character. Output filename
(e.g users/datacolecfbf/ic_moved)}

\item{add_properties}{List. Set of parameters to established as a property
of an EE object. See details.}

\item{del_properties}{Character. Names of properties to be deleted. See
details.}

\item{owner}{Character vector. Define owner user in the IAM Policy.}

\item{editor}{Character vector. Define editor users in the IAM Policy.}

\item{viewer}{Character vector. Define viewer users in the IAM Policy.}

\item{all_users_can_read}{Logical. All users can see the asset element.}

\item{cache}{Logical. If TRUE, the task report will be saved
in the /temp directory and used when the function.}
}
\description{
R functions to manage the Earth Engine Asset. The interface allows users
to create and eliminate folders, move and copy assets, set and delete
properties, handle access control lists, and manage and/or cancel tasks.
}
\details{
If the argument \code{del_properties} is 'ALL',
\link[=rgee]{ee_manage_delete_properties} will delete all
the properties.
}
\examples{
\dontrun{
library(rgee)

ee_Initialize()
ee_user_info()

# Change datacolecfbf by your EE user to be able to reproduce
user <- ee_get_assethome()
addm <- function(x) sprintf("\%s/\%s",user, x)
# 1. Create a folder or Image Collection
# Change path asset according to your specific user
ee_manage_create(addm("rgee"))

# 1. List all the elements inside a folder or a ImageCollection
ee_manage_assetlist(path_asset = addm("rgee"))

# 2. Create a Folder or a ImageCollection
ee_manage_create(
  path_asset = addm("rgee/rgee_folder"),
  asset_type = "Folder"
)

ee_manage_create(
  path_asset = addm("rgee/rgee_ic"),
  asset_type = "ImageCollection"
)

ee_manage_assetlist(path_asset = addm("rgee"))

# 3. Shows Earth Engine quota
ee_manage_quota()

# 4. Move an EE object to another folder
ee_manage_move(
  path_asset = addm("rgee/rgee_ic"),
  final_path = addm("rgee/rgee_folder/rgee_ic_moved")
)

ee_manage_assetlist(path_asset = addm("rgee/rgee_folder"))

# 5. Set properties to an EE object.
ee_manage_set_properties(
  path_asset = addm("rgee/rgee_folder/rgee_ic_moved"),
  add_properties = list(message = "hello-world", language = "R")
)

ic_id <- addm("rgee/rgee_folder/rgee_ic_moved")
test_ic <- ee$ImageCollection(ic_id)
test_ic$getInfo()

# 6. Delete properties
ee_manage_delete_properties(
  path_asset = addm("rgee/rgee_folder/rgee_ic_moved"),
  del_properties = c("message", "language")
)
test_ic$getInfo()

# 7. Create a report based on all the tasks
# that are running or have already been completed.
ee_manage_task()

# 8. Cancel all the running task
ee_manage_cancel_all_running_task()

# 9. Delete EE objects or folders
ee_manage_delete(addm("rgee/"))
}
}
\author{
Samapriya Roy, adapted to R and improved by csaybar.
}
