% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2_functions.R
\name{r2_functions}
\alias{r2_functions}
\alias{r2_1.0_1.0}
\alias{r2_1.0_1.1}
\alias{r2_1.1_1.1}
\title{Calculate recombination frequency, LOD and log-likelihood from frequency tables in a random pairing diploid cross.}
\usage{
r2_1.0_1.0(x, ncores = 1)

r2_1.0_1.1(x, ncores = 1)

r2_1.1_1.1(x, ncores = 1)
}
\arguments{
\item{x}{A frequency table of the different classes of dosages in the progeny. The column names start with \code{"n_"}. Followed by the dosage of the first marker and then of the second.}

\item{ncores}{Number of cores to use for parallel processing (deprecated).}
}
\value{
A list with the following items:
\item{r_mat}{A matrix with recombination frequencies for the different phases}
\item{LOD_mat}{A matrix with LOD scores for the different phases}
\item{logL_mat}{A matrix with log likelihood ratios for the different phases}
\item{phasing_strategy}{A character string specifying the phasing strategy. \code{"MLL"} for maximum likelihood en \code{"MINR"} for minimum recombination frequency.}
\item{possible_phases}{The phases between markers that are possible. Same order and length as column names of output matrices.}
}
\description{
This group of functions is called by \code{\link{linkage}}.
}
