% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transPk.R
\name{addLogEstimates}
\alias{addLogEstimates}
\title{Add log estimates to a model}
\usage{
addLogEstimates(ui, vars, extraLines = NULL, beforeCmt = NULL)
}
\arguments{
\item{ui}{rxode2 model}

\item{vars}{estimates to add they will be parameterized as:

\code{var <- exp(lvar)}

where \code{var} is the variable name in the model and \code{lvar}
is the log transformed variable that will be estimated}

\item{extraLines}{this is a list of additional lines to add to the
model just after the variables are defined.  It must be
\code{NULL} or a list of \code{language} objects.}

\item{beforeCmt}{if the model is compartmental you can specify the
preferred names where the estimates and extra lines are added before}
}
\value{
rxode2 model with log estimates added (and possibly extra lines)
}
\description{
Add log estimates to a model
}
\examples{

# Change the transformation of the PK model from cl to k

readModelDb("PK_3cmt_des") |>
  removeLinesAndInis(c("kel", "k12", "k21", "k13", "k31", "vc")) |>
  addLogEstimates(c("kel", "k12", "k21", "k13", "k31", "vc"))

# You can also label the parameters by using a named character
# vector with the names of the parameters representing the
# variables and the values representing the labels:

readModelDb("PK_3cmt_des") |>
  removeLinesAndInis(c("kel", "k12", "k21", "k13", "k31", "vc")) |>
  addLogEstimates(c(kel="elimination", k12="k12 constant",
                    k21="k21 constant",
                    k13="k13 constant",
                    k31="k31 constant",
                    vc="volume of central compartment"))

}
\author{
Matthew L. Fidler
}
