% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuse.R
\name{reactor}
\alias{reactor}
\title{Get and set chunk options}
\usage{
reactor(...)
}
\arguments{
\item{...}{Named values (for setting) or unnamed values (for getting).}
}
\value{
With no arguments, \code{reactor()} returns an environment that stores the
options, which can also be used to get or set options. For example, with
\code{opts = reactor()}, \code{opts$name} returns an option value, and \code{opts$name = value} sets an option to a value.

With named arguments, \code{reactor()} sets options and returns a list of their
old values (e.g., \code{reactor(echo = FALSE, fig.width = 8)}). The returned
list can be passed to \code{reactor()} later to restore the options.

With unnamed arguments, \code{reactor()} returns option values after received
option names as input. If one name is received, its value is returned
(e.g., \code{reactor('echo')}). If multiple names are received, a named list of
values is returned (e.g., \code{reactor(c('echo', 'fig.width'))}). A special
case is that if only one unnamed argument is received and it takes a list
of named values, the list will be used to set options, e.g.,
\code{reactor(list(echo = FALSE, fig.width = 8))}, which is equivalent to
\code{reactor(echo = FALSE, fig.width = 8)}.
}
\description{
Chunk options are stored in an environment returned by \code{reactor()}. Option
values can be queried by passing their names to \code{reactor()}, and set by
passing named values.
}
\examples{
# get options
litedown::reactor("echo")
litedown::reactor(c("echo", "fig.width"))

# set options
old = litedown::reactor(echo = FALSE, fig.width = 8)
litedown::reactor(c("echo", "fig.width"))
litedown::reactor(old)  # restore options

# use the environment directly
opts = litedown::reactor()
opts$echo
mget(c("echo", "fig.width"), opts)
ls(opts)  # built-in options
}
