% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_statistics.R
\name{dimnames<-.hstats_matrix}
\alias{dimnames<-.hstats_matrix}
\title{Dimnames (Replacement Method) of "hstats_matrix"}
\usage{
\method{dimnames}{hstats_matrix}(x) <- value
}
\arguments{
\item{x}{An object of class "hstats_matrix".}

\item{value}{A list with rownames and column names compliant with \verb{$M} (and \verb{$SE}).}
}
\value{
Like \code{x}, but with replaced dimnames.
}
\description{
This implies \code{colnames(x) <- ...}.
}
\examples{
fit <- lm(as.matrix(iris[1:2]) ~ Petal.Length + Petal.Width * Species, data = iris)
s <- hstats(fit, X = iris[3:5], verbose = FALSE)
x <- h2_overall(s)
colnames(x) <- c("Sepal Length", "Sepal Width")
plot(x)

rownames(x)[2:3] <- c("Petal Width", "Petal Length")
plot(x)
}
