#' Comment Example Dataset
#'
#' Participant comments for the initial description used in the jury perception
#' study
#'
#'
#' @format ## `comment_example`
#' A data frame with 125 rows and 2 columns:
#' \describe{
#'   \item{ID}{Participant Identifier}
#'   \item{Notes}{Participant notes}
#'
#' }
#' @source Jury Perception Study (see Rogers (2024) <https://digitalcommons.unl.edu/dissertations/AAI31240449/>)
"comment_example"


#' Transcript Example
#'
#' Text corresponding to participant comments
#'
#'
#' @format ## `transcript_example`
#' A data frame with 1 row and 1 column:
#' \describe{
#'   \item{Text}{Transcript text corresponding to the jury perception study}
#'
#' }
#' @source Jury Perception Study (see Rogers (2024) <https://digitalcommons.unl.edu/dissertations/AAI31240449/> and Garrett et. al. (2020) <doi:10.1037/lhb0000423>)
"transcript_example"

#' Wikipedia Edit History for "Highlighter"
#'
#' Text corresponding to versions of the Wikipedia article for Highlighter
#'
#'
#' @format ## `wiki_pages`
#' A data frame with 300 rows and 1 column:
#' \describe{
#'   \item{page_notes}{text of the Wikipedia page for Highlighter}
#'
#' }
#' @source Wikipedia: https://en.wikipedia.org/w/index.php?title=Highlighter&action=history
"wiki_pages"
