% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorplot.R
\name{fp_to_df}
\alias{fp_to_df}
\title{Convert factorplot output to data frame}
\usage{
fp_to_df(obj, type = c("upper_tri", "both_tri"), ...)
}
\arguments{
\item{obj}{An object of class `factorplot` produced by the `factorplot()` function from the `factorplot` package.}

\item{type}{Indicates whether you want the resulting plot to have differences on the upper triangle and p-values on the lower triangle (if `"both_tri"`) or 
both p-values and differences to be plotted in the upper triangle.}

\item{...}{Other arguments, currently ignored.}
}
\value{
A data frame with columns
 - `row`: The name of the parameter in the row
 - `col`: The name of the parameter in the column
 - `estimate`: The estimate for the parameter (on the diagonal)
 - `difference`: Pairwise differences between parameters. 
 - `p_value`: The p-value of the pairwise difference.
}
\description{
Converts the output from factorplot to a data frame that is convenient for custom plotting.  
The plot method for factorplot objects from the factorplot package will produce a plot that is 
lightly customisable.  However,  for more control over the appearance of the plot, and to plot estimates
on the diagnoal of the display, returning the data and making a plot is easier.
}
\examples{
library(factorplot)
library(ggplot2)
data(chickwts)
mod <- lm(weight ~ feed, data=chickwts)
fp <- factorplot(mod, factor.variable = "feed", order="size")
chick_df <- fp_to_df(fp, type="upper_tri")
ggplot(chick_df, aes(x=row, y=column)) + 
  geom_tile(aes(fill=difference), color="black") + 
  geom_text(aes(label = ifelse(p_value < .05, "*", "")), color="white", size=10) + 
  scale_fill_viridis_c(option = "D", na.value = "transparent") + 
  theme_classic() + 
  geom_text(data=chick_df, 
            aes(x=row, y=column, label=round(estimate, 2))) + 
  labs(fill="Difference", x="", y="")
}
