% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fisherTestInfo}
\alias{fisherTestInfo}
\title{Fisher's Test Information}
\usage{
fisherTestInfo(catObj, theta)
}
\arguments{
\item{catObj}{An object of class \code{Cat}}

\item{theta}{A numeric indicating the position on the latent trait.}
}
\value{
The function \code{fisherTestInfo} returns a numeric indicating the total information gained for a respondent,
 given a specific answer set and the current estimate of \eqn{\theta}.
}
\description{
Calculates the total information gained for a respondent for all answered items, conditioned on \eqn{\theta}.
}
\note{
This function is to allow users to access the internal functions of the package. During item selection, all calculations are done in compiled \code{C++} code.
}
\examples{
## Loading ltm Cat object
data(ltm_cat)

## Store example answers
setAnswers(ltm_cat) <- c(1,0,1,0,1, rep(NA, 35))

## Fisher's test information for answer profile
fisherTestInfo(ltm_cat, theta = 2)


}
\seealso{
\code{\link{fisherInf}}
}
\author{
Haley Acevedo, Ryden Butler, Josh W. Cutler, Matt Malis, Jacob M. Montgomery,
 Tom Wilkinson, Erin Rossiter, Min Hee Seo, Alex Weil
}
