% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{consensus.instruments}
\alias{consensus.instruments}
\title{Meta-data on Instruments for the dataset of the CONSENSUS research project.}
\format{
A data frame (tibble) containing the characteristics of Instruments, namely the Sector, the type of Instrument and the internal id in the original coding manual.
}
\source{
Consensus research project (217239): https://cordis.europa.eu/project/id/217239
}
\usage{
data(consensus.instruments)
}
\description{
A tidy dataset of the characteristics of Instruments in social and environmental policies for the CONSENSUS research project.
}
\details{
When using the dataset, please cite:

Fernández-i-Marín, X., Knill, C. & Steinebach, Y. (2021). Studying Policy Design Quality in Comparative Perspective. _American Political Science Review_, online first.

Knill, C., Schulze, K. & Tosun, J. (2012). Regulatory Policy Outputs and Impacts. Exploring a Complex Relationship. _Regulation & Governance_, 5(4), 427-444. doi:10.1111/j.1748-5991.2012.01150.x.
}
\examples{
data(consensus.instruments)
str(consensus.instruments)
}
\references{
Fernández-i-Marín, X., Knill, C. & Steinebach, Y. (2021). Studying Policy Design Quality in Comparative Perspective. _American Political Science Review_, online first.

Knill, C., Schulze, K. & Tosun, J. (2012). Regulatory Policy Outputs and Impacts. Exploring a Complex Relationship. _Regulation & Governance_, 5(4), 427-444. doi:10.1111/j.1748-5991.2012.01150.x.
}
\seealso{
\code{\link{consensus}} for the full dataset and \code{\link{consensus.targets}} for meta data about Target id and Subsector.
}
\keyword{datasets}
