% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engine_hybrid.R
\name{stop_engine_on_first_of}
\alias{stop_engine_on_first_of}
\title{an utility function to easily generate the commonly used \code{until} parameter, as used by \code{\link[=fuzzycoco_fit_df_hybrid]{fuzzycoco_fit_df_hybrid()}}}
\usage{
stop_engine_on_first_of(
  max_generations = NULL,
  max_fitness = NULL,
  other_func = NULL
)
}
\arguments{
\item{max_generations}{The maximum number of iterations of the algorithm.
Each iteration produces a new generation of the rules and membership functions populations.}

\item{max_fitness}{a stop condition: the iterations stop as soon as a generated fuzzy system fitness
reaches that threshold.}

\item{other_func}{if not NULL, a function: (engine) -->logical that should return TRUE to stop the evolution
(cf \code{\link[=stop_engine_if_stalling]{stop_engine_if_stalling()}})}
}
\value{
a function: (engine) --> logical that stops (i.e/ returns TRUE) when the number of generations or the fitness
are reached, or when the \code{other_func} if provided returns TRUE
}
\description{
an utility function to easily generate the commonly used \code{until} parameter, as used by \code{\link[=fuzzycoco_fit_df_hybrid]{fuzzycoco_fit_df_hybrid()}}
}
\examples{
until <- stop_engine_on_first_of(max_generations = 100)
until <- stop_engine_on_first_of(max_generations = 100, max_fitness = 0.8)
until <- stop_engine_on_first_of(max_fitness = 0.9, other_func = stop_engine_if_stalling(5))
}
