% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_vis_lr.R
\name{circle_plot}
\alias{circle_plot}
\title{Plot Circular Ligand-Receptor Interaction Network}
\usage{
circle_plot(
  filtered_lr,
  edge_width = c("count", "cor"),
  node_colors = NULL,
  show_self_interactions = TRUE,
  cutoff = 0
)
}
\arguments{
\item{filtered_lr}{A data frame of ligand-receptor pairs from prior analysis (e.g., output of \code{filter_lr_all}),
containing at least the columns "sender", "receiver", and "cor".}

\item{edge_width}{Determines edge weights, either "cor" (correlation) or "count" (interaction count) (default: "count").}

\item{node_colors}{Named vector mapping cell types to colors. Example: c("Cardiac" = "#E41A1C", "Fibroblast" = "#377EB8"). If NULL, uses default palette.}

\item{show_self_interactions}{Logical indicating whether to display self-interactions (logical, default: TRUE).}

\item{cutoff}{Minimum edge weight to display (numeric, default: 0).}
}
\value{
A ggplot object representing the network plot.
}
\description{
Plots a circular ligand-receptor (LR) interaction network with curved directed edges.
Nodes are arranged in a circle, and edge widths and colors represent interaction strengths.
}
\examples{
# Plot Circular Cell-Cell Interaction Network
data(filtered_lr_eg)

p <- circle_plot(
  filtered_lr = filtered_lr_eg,
  edge_width = "count",
  show_self_interactions = TRUE
)

print(p)
}
