% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UCM.R
\name{UCM}
\alias{UCM}
\title{Ultrametric Correlation Matrix}
\usage{
UCM(R, m, rndstart, maxiter = 100, eps = 1e-06)
}
\arguments{
\item{R}{(\eqn{p \times p}) nonnegative correlation matrix.}

\item{m}{Integer specifying the number of variable groups.}

\item{rndstart}{Integer value specifying the number of random starts.}

\item{maxiter}{Integer value specifying the maximum number of iterations of the EM algorithm (default: maxiter = 100).}

\item{eps}{Numeric value specifying the tolerance for the convergence criterion used in the coordinate descent algorithm (default: eps = 1e-6).}
}
\value{
A list with the following elements: \cr

\code{call} Matched call.

\code{V} Optimal binary and row-stochastic (\eqn{p \times m}) variable-group membership matrix.

\code{Rt} Optimal (\eqn{p \times p}) ultrametric correlation matrix.

\code{Rw} Optimal (\eqn{m \times m}) within-concept consistency (diagonal) matrix.

\code{Rb} Optimal (\eqn{m \times m}) between-concept correlation matrix.

\code{of} Objective function corresponding to the optimal solution.

\code{loop} Random start corresponding to the optimal solution.

\code{iter} Number of iterations needed to obtain the optimal solution.
}
\description{
Fit an ultrametric correlation matrix on a nonnegative correlation one.
}
\examples{
data(penguins)
R <- cor(penguins[, 2:5])
UCM(R, 4, 1)
}
\references{
Cavicchia, C., Vichi, M., Zaccaria, G. (2020) The ultrametric correlation matrix for modelling hierarchical latent concepts. \emph{Advances in Data Analysis and Classification}, 14(4), 837-853.
}
