% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{handle_missing_values}
\alias{handle_missing_values}
\title{Handle Missing Values in MEA Data}
\usage{
handle_missing_values(data, value_column, method, verbose)
}
\arguments{
\item{data}{Data frame containing MEA data}

\item{value_column}{Character string specifying the column with values to process}

\item{method}{Character string specifying handling method: "remove", "impute_mean", "impute_zero"}

\item{verbose}{Logical indicating whether to print progress messages}
}
\value{
Data frame with missing values handled according to specified method
}
\description{
Handles missing values in MEA datasets using various imputation strategies
or removal methods.
}
\examples{
test_data <- data.frame(
  ID = 1:10,
  Value = c(1.2, NA, 3.4, 2.1, NA, 5.6, 4.3, NA, 2.8, 3.9)
)
cleaned <- handle_missing_values(test_data, "Value", "remove", FALSE)

}
