% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNovelCells.R
\name{plotNovelCells}
\alias{plotNovelCells}
\title{Plot the identified outlier cells in the voronoi tessellation map.}
\usage{
plotNovelCells(
  plot.cells,
  hvt.map,
  line.width = c(0.6),
  color.vec = c("#141B41"),
  pch = 21,
  centroid.size = 0.5,
  title = NULL,
  maxDepth = 1
)
}
\arguments{
\item{plot.cells}{Vector. A vector indicating the cells to be highlighted in the map}

\item{hvt.map}{List. A list containing the output of \code{trainHVT} function
which has the details of the tessellations to be plotted}

\item{line.width}{Numeric Vector. A vector indicating the line widths of the
tessellation boundaries for each level}

\item{color.vec}{Vector. A vector indicating the colors of the boundaries of
the tessellations at each level}

\item{pch}{Numeric. Symbol of the centroids of the tessellations
(parent levels) Default value is 21.}

\item{centroid.size}{Numeric. Size of centroids of first level
tessellations. Default value is 0.5}

\item{title}{String. Set a title for the plot. (default = NULL)}

\item{maxDepth}{Numeric. An integer indicating the number of levels. (default = NULL)}
}
\value{
Returns a ggplot object containing hierarchical voronoi tessellation plot
highlighting the outlier cells
}
\description{
This is the main plotting function to construct hierarchical voronoi tessellations 
and highlight the outlier cells
}
\examples{
data("EuStockMarkets")
hvt.results <- trainHVT(EuStockMarkets, n_cells = 60, depth = 1, quant.err = 0.1, 
                       distance_metric = "L1_Norm", error_metric = "max",
                       normalize = TRUE,quant_method="kmeans")
#selected 55,58 are for demo purpose
plotNovelCells(c(55,58),hvt.results)
}
\seealso{
\code{\link{trainHVT}} \cr \code{\link{plotHVT}}
}
\author{
Shantanu Vaidya <shantanu.vaidya@mu-sigma.com>
}
\keyword{Novelty_or_Outliers}
