% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DefaultTemporalSequenceCovariateSettings.R
\name{createTemporalSequenceCovariateSettings}
\alias{createTemporalSequenceCovariateSettings}
\title{Create covariate settings}
\usage{
createTemporalSequenceCovariateSettings(
  useDemographicsGender = FALSE,
  useDemographicsAge = FALSE,
  useDemographicsAgeGroup = FALSE,
  useDemographicsRace = FALSE,
  useDemographicsEthnicity = FALSE,
  useDemographicsIndexYear = FALSE,
  useDemographicsIndexMonth = FALSE,
  useConditionOccurrence = FALSE,
  useConditionOccurrencePrimaryInpatient = FALSE,
  useConditionEraStart = FALSE,
  useConditionEraGroupStart = FALSE,
  useDrugExposure = FALSE,
  useDrugEraStart = FALSE,
  useDrugEraGroupStart = FALSE,
  useProcedureOccurrence = FALSE,
  useDeviceExposure = FALSE,
  useMeasurement = FALSE,
  useMeasurementValue = FALSE,
  useObservation = FALSE,
  timePart = "month",
  timeInterval = 1,
  sequenceEndDay = -1,
  sequenceStartDay = -730,
  includedCovariateConceptIds = c(),
  addDescendantsToInclude = FALSE,
  excludedCovariateConceptIds = c(),
  addDescendantsToExclude = FALSE,
  includedCovariateIds = c()
)
}
\arguments{
\item{useDemographicsGender}{Gender of the subject. (analysis ID 1)}

\item{useDemographicsAge}{Age of the subject on the index date (in years).
(analysis ID 2)}

\item{useDemographicsAgeGroup}{Age of the subject on the index date (in 5 year age
groups) (analysis ID 3)}

\item{useDemographicsRace}{Race of the subject. (analysis ID 4)}

\item{useDemographicsEthnicity}{Ethnicity of the subject. (analysis ID 5)}

\item{useDemographicsIndexYear}{Year of the index date. (analysis ID 6)}

\item{useDemographicsIndexMonth}{Month of the index date. (analysis ID 7)}

\item{useConditionOccurrence}{One covariate per condition in the
condition_occurrence table starting in the time
window. (analysis ID 101)}

\item{useConditionOccurrencePrimaryInpatient}{One covariate per condition observed as a primary
diagnosis in an inpatient setting in the
condition_occurrence table starting in the time
window. (analysis ID 102)}

\item{useConditionEraStart}{One covariate per condition in the condition_era
table starting in the time window. (analysis ID 201)}

\item{useConditionEraGroupStart}{One covariate per condition era rolled up to SNOMED
groups in the condition_era table starting in the
time window. (analysis ID 203)}

\item{useDrugExposure}{One covariate per drug in the drug_exposure table
starting in the time window. (analysis ID 301)}

\item{useDrugEraStart}{One covariate per drug in the drug_era table
starting in the time window. (analysis ID 401)}

\item{useDrugEraGroupStart}{One covariate per drug rolled up to ATC groups in
the drug_era table starting in the time window.
(analysis ID 403)}

\item{useProcedureOccurrence}{One covariate per procedure in the
procedure_occurrence table in the time window.
(analysis ID 501)}

\item{useDeviceExposure}{One covariate per device in the device exposure
table starting in the timewindow. (analysis ID 601)}

\item{useMeasurement}{One covariate per measurement in the measurement
table in the time window. (analysis ID 701)}

\item{useMeasurementValue}{One covariate containing the value per
measurement-unit combination in the time window. If
multiple values are found, the last is taken.
(analysis ID 702)}

\item{useObservation}{One covariate per observation in the observation
table in the time window. (analysis ID 801)}

\item{timePart}{The interval scale ('DAY', 'MONTH', 'YEAR')}

\item{timeInterval}{Fixed interval length for timeId using the 'timePart' scale.  For example, a 'timePart' of DAY with
'timeInterval' 30 has timeIds where timeId 1 is day 0 to day 29, timeId 2 is day 30 to day 59, etc.}

\item{sequenceEndDay}{What is the end day (relative to the
index date) of the data extraction?}

\item{sequenceStartDay}{What is the start day (relative to the
index date) of the data extraction?}

\item{includedCovariateConceptIds}{A list of concept IDs that should be used to
construct covariates.}

\item{addDescendantsToInclude}{Should descendant concept IDs be added to the list
of concepts to include?}

\item{excludedCovariateConceptIds}{A list of concept IDs that should NOT be used to
construct covariates.}

\item{addDescendantsToExclude}{Should descendant concept IDs be added to the list
of concepts to exclude?}

\item{includedCovariateIds}{A list of covariate IDs that should be restricted
to.}
}
\value{
An object of type \code{covariateSettings}, to be used in other functions.
}
\description{
Create covariate settings
}
\details{
creates an object specifying how covariates should be constructed from data in the CDM model.
}
\examples{
settings <- createTemporalSequenceCovariateSettings(
  useDemographicsGender = TRUE,
  useDemographicsAge = FALSE,
  useDemographicsAgeGroup = TRUE,
  useDemographicsRace = TRUE,
  useDemographicsEthnicity = TRUE,
  useDemographicsIndexYear = TRUE,
  useDemographicsIndexMonth = TRUE,
  useConditionOccurrence = FALSE,
  useConditionOccurrencePrimaryInpatient = FALSE,
  useConditionEraStart = FALSE,
  useConditionEraGroupStart = FALSE,
  useDrugExposure = FALSE,
  useDrugEraStart = FALSE,
  useDrugEraGroupStart = FALSE,
  useProcedureOccurrence = TRUE,
  useDeviceExposure = TRUE,
  useMeasurement = TRUE,
  useMeasurementValue = FALSE,
  useObservation = TRUE,
  timePart = "DAY",
  timeInterval = 1,
  sequenceEndDay = -1,
  sequenceStartDay = -730,
  includedCovariateConceptIds = c(),
  addDescendantsToInclude = FALSE,
  excludedCovariateConceptIds = c(),
  addDescendantsToExclude = FALSE,
  includedCovariateIds = c()
)

}
